/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.event.HearthSaveDataHandler;
import com.momosoftworks.coldsweat.core.network.message.DisableHearthParticlesMessage;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class AbstractHearthScreen<T extends AbstractContainerMenu>
extends EffectRenderingInventoryScreen<T> {
    private static final WidgetSprites PARTICLES_ENABLED_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"hearth/hearth_particle_button_on"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"hearth/hearth_particle_button_on_focus"));
    private static final WidgetSprites PARTICLES_DISABLED_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"hearth/hearth_particle_button_off"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"hearth/hearth_particle_button_off_focus"));
    ImageButton particleButton = null;
    Pair<BlockPos, ResourceLocation> levelPos = Pair.of((Object)this.getBlockEntity().getBlockPos(), (Object)this.getBlockEntity().getLevel().dimension().location());
    boolean hideParticles;
    boolean hideParticlesOld = this.hideParticles = HearthSaveDataHandler.DISABLED_HEARTHS.contains(this.levelPos);
    private WidgetSprites particleButtonSprites = this.hideParticles ? PARTICLES_DISABLED_SPRITES : PARTICLES_ENABLED_SPRITES;

    abstract HearthBlockEntity getBlockEntity();

    public AbstractHearthScreen(T screenContainer, Inventory inv, Component title) {
        super(screenContainer, inv, title);
    }

    public void init() {
        super.init();
        if (this.getBlockEntity().hasSmokeStack()) {
            this.particleButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 82, this.topPos + 68, 12, 12, this.particleButtonSprites, button -> {
                boolean bl = this.hideParticles = !this.hideParticles;
                if (this.hideParticles) {
                    HearthSaveDataHandler.DISABLED_HEARTHS.add(this.levelPos);
                    if (HearthSaveDataHandler.DISABLED_HEARTHS.size() > 64) {
                        HearthSaveDataHandler.DISABLED_HEARTHS.remove(HearthSaveDataHandler.DISABLED_HEARTHS.iterator().next());
                    }
                    this.particleButtonSprites = PARTICLES_DISABLED_SPRITES;
                } else {
                    HearthSaveDataHandler.DISABLED_HEARTHS.remove(this.levelPos);
                    this.particleButtonSprites = PARTICLES_ENABLED_SPRITES;
                }
                AbstractHearthScreen.setImageButtonSprites(this.particleButton, this.particleButtonSprites);
            }){

                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    if (this.active && this.visible && this.isValidClickButton(button) && this.clicked(mouseX, mouseY)) {
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.STONE_BUTTON_CLICK_ON, (float)(!AbstractHearthScreen.this.hideParticles ? 1.5f : 1.9f), (float)0.75f));
                        this.onClick(mouseX, mouseY);
                        this.setFocused(false);
                        return true;
                    }
                    return false;
                }
            });
            this.particleButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"cold_sweat.screen.hearth.show_particles")));
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        this.children().forEach(child -> child.setFocused(false));
    }

    public void onClose() {
        super.onClose();
        if (this.minecraft.player != null && this.hideParticlesOld != this.hideParticles) {
            PacketDistributor.sendToServer((CustomPacketPayload)new DisableHearthParticlesMessage(HearthSaveDataHandler.serializeDisabledHearths()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static void setImageButtonSprites(ImageButton button, WidgetSprites sprites) {
        try {
            Field field = ObfuscationReflectionHelper.findField(ImageButton.class, (String)"sprites");
            field.setAccessible(true);
            field.set(button, sprites);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

