/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class WaterTempModifier
extends TempModifier {
    private static final double WATER_SOAK_SPEED = 0.1;
    private static final double RAIN_SOAK_SPEED = 0.0125;
    private static final double DRY_SPEED = 0.0015;

    public WaterTempModifier() {
        this(0.01);
    }

    public WaterTempModifier(double strength) {
        this.getNBT().putDouble("Strength", strength);
    }

    public double getWetness() {
        return this.getNBT().getDouble("Strength");
    }

    public double getMaxStrength(LivingEntity entity) {
        double worldTemp = Temperature.get(entity, Temperature.Trait.WORLD);
        double maxTemp = ConfigSettings.MAX_TEMP.get();
        double minTemp = ConfigSettings.MIN_TEMP.get();
        return CSMath.clamp(Math.abs(CSMath.average(maxTemp, minTemp) - worldTemp) / 2.0, 0.23, 0.5);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        double worldTemp = Temperature.get(entity, Temperature.Trait.WORLD);
        double minTemp = ConfigSettings.MIN_TEMP.get();
        double maxTemp = ConfigSettings.MAX_TEMP.get();
        double midTemp = CSMath.average(minTemp, maxTemp);
        double configDrySpeed = ConfigSettings.DRYOFF_SPEED.get() * 0.0015;
        double strength = this.getNBT().getDouble("Strength");
        double addAmount = WorldHelper.isInWater((Entity)entity) ? 0.1 : (WorldHelper.isRainingAt(entity.level(), entity.blockPosition()) ? 0.0125 : -CSMath.blendExp(configDrySpeed, configDrySpeed * 10.0, worldTemp, minTemp, maxTemp, 100.0));
        double maxStrength = CSMath.clamp(Math.abs(midTemp - worldTemp) / 2.0, 0.23, 0.5);
        double newStrength = CSMath.clamp(strength + addAmount, 0.0, maxStrength);
        this.getNBT().putDouble("Strength", newStrength);
        if (strength != newStrength) {
            this.markDirty();
        }
        if (strength <= 0.0) {
            this.expires(0);
        }
        return temp -> temp - newStrength;
    }

    @Override
    public void tick(LivingEntity entity) {
        if (entity.level().isClientSide() && ConfigSettings.WATER_EFFECT_SETTING.get().showParticles() && !entity.isInWater() && Math.random() < this.getNBT().getDouble("Strength") * 2.0) {
            double randX = (double)entity.getBbWidth() * (Math.random() - 0.5);
            double randY = (double)entity.getBbHeight() * Math.random();
            double randZ = (double)entity.getBbWidth() * (Math.random() - 0.5);
            entity.level().addParticle((ParticleOptions)ParticleTypes.FALLING_WATER, entity.getX() + randX, entity.getY() + randY, entity.getZ() + randZ, 0.0, 0.0, 0.0);
        }
    }
}

