/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemCarryTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InventoryItemsTempModifier
extends TempModifier {
    private final Map<Temperature.Trait, Double> effectsPerTrait = new EnumMap<Temperature.Trait, Double>(Temperature.Trait.class);

    public InventoryItemsTempModifier(double temp) {
        this.getNBT().putDouble("Effect", temp);
    }

    public InventoryItemsTempModifier() {
        this(0.0);
    }

    @Override
    protected Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        return temp -> temp + this.effectsPerTrait.getOrDefault((Object)trait, 0.0);
    }

    @Override
    public void tick(LivingEntity entity) {
        this.effectsPerTrait.clear();
        HashMap effectsPerCarriedTemp = new HashMap();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = entity.getItemBySlot(slot);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().get((Object)item).forEach(carried -> InventoryItemsTempModifier.checkAndAddCarriedTemp(entity, stack, null, slot, carried, effectsPerCarriedTemp));
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (Slot slot : player.inventoryMenu.slots) {
                ItemStack stack = slot.getItem();
                if (stack.isEmpty()) continue;
                Item item = stack.getItem();
                ConfigSettings.CARRIED_ITEM_TEMPERATURES.get().get((Object)item).forEach(carried -> InventoryItemsTempModifier.checkAndAddCarriedTemp(entity, stack, slot.index, null, carried, effectsPerCarriedTemp));
            }
        }
        for (Map.Entry entry : effectsPerCarriedTemp.entrySet()) {
            Temperature.Trait dataTrait = ((ItemCarryTempData)entry.getKey()).trait();
            double temp = (Double)entry.getValue();
            this.effectsPerTrait.put(dataTrait, this.effectsPerTrait.getOrDefault((Object)dataTrait, 0.0) + temp);
        }
    }

    private static void checkAndAddCarriedTemp(LivingEntity entity, ItemStack stack, Integer slot, EquipmentSlot equipmentSlot, ItemCarryTempData carried, Map<ItemCarryTempData, Double> effectsPerCarriedTemp) {
        if (carried.test((Entity)entity, stack, slot, equipmentSlot)) {
            double temp = carried.temperature() * (double)stack.getCount();
            double currentEffect = effectsPerCarriedTemp.getOrDefault(carried, 0.0);
            double newEffect = Math.min(carried.maxEffect(), Math.abs(currentEffect + temp)) * (double)CSMath.sign(currentEffect + temp);
            effectsPerCarriedTemp.put(carried, newEffect);
        }
    }
}

