/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class ElevationTempModifier
extends TempModifier {
    public ElevationTempModifier() {
        this(49);
    }

    public ElevationTempModifier(int samples) {
        this.getNBT().putInt("Samples", samples);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        Level level = entity.level();
        DimensionTempData dimTempOverride = ConfigSettings.DIMENSION_TEMPS.get(entity.level().registryAccess()).get(level.dimensionTypeRegistration());
        if (dimTempOverride != null) {
            return temp -> temp;
        }
        if (level.dimensionType().hasCeiling()) {
            return temp -> temp;
        }
        ArrayList<Pair> depthTable = new ArrayList<Pair>();
        for (BlockPos pos : WorldHelper.getPositionGrid(entity.blockPosition(), this.getNBT().getInt("Samples"), 10)) {
            depthTable.add(Pair.of((Object)pos, (Object)CSMath.getDistance((Vec3i)entity.blockPosition(), (Vec3i)pos)));
        }
        int skylight = entity.level().getBrightness(LightLayer.SKY, entity.blockPosition());
        ArrayList<Pair> depthRegions = new ArrayList<Pair>(depthTable.size());
        block1: for (Pair pair : depthTable) {
            int groundLevel;
            int minY;
            BlockPos originalPos = (BlockPos)pair.getFirst();
            int originalY = originalPos.getY();
            int adjustedY = CSMath.betweenInclusive(originalY, minY = level.getMinBuildHeight(), groundLevel = WorldHelper.getHeight(originalPos, level)) ? CSMath.clamp(originalY + skylight - 4, minY, groundLevel) : (originalY >= groundLevel ? CSMath.clamp(originalY + skylight - 4, groundLevel, originalY) : CSMath.clamp(originalY + skylight - 4, originalY, minY));
            BlockPos pos = new BlockPos(originalPos.getX(), adjustedY, originalPos.getZ());
            double distance = (Double)pair.getSecond();
            for (DepthTempData data : ConfigSettings.DEPTH_REGIONS.get()) {
                DepthTempData.TempRegion region = data.getRegion(level, pos);
                if (region == null) continue;
                int regionMax = region.top().getHeight(pos, level);
                int regionMin = region.bottom().getHeight(pos, level);
                depthRegions.add(Pair.of((Object)new Elevation(pos, originalPos), (Object)new RegionEntry(region, distance, regionMin, regionMax)));
                continue block1;
            }
            depthRegions.add(Pair.of((Object)new Elevation(pos, originalPos), (Object)new RegionEntry(null, distance, 0, 0)));
        }
        double midTemp = Temperature.getNeutralWorldTemp(entity);
        return temp -> {
            ArrayList depthTemps = new ArrayList();
            for (Pair entry : depthRegions) {
                BlockPos pos;
                Elevation elevation = (Elevation)entry.getFirst();
                RegionEntry regionEntry = (RegionEntry)entry.getSecond();
                BlockPos blockPos = pos = temp >= midTemp ? elevation.lightPos() : elevation.pos();
                DepthTempData.TempRegion region = regionEntry.region();
                if (region == null) continue;
                double distance = regionEntry.distance();
                int maxY = regionEntry.maxY();
                int minY = regionEntry.minY();
                double depthTemp = region.getTemperature((double)temp, pos, level, maxY, minY);
                double weight = 1.0 / (distance / 10.0 + 1.0);
                depthTemps.add(new Pair((Object)depthTemp, (Object)weight));
            }
            if (depthTemps.isEmpty()) {
                return temp;
            }
            return CSMath.weightedAverage(depthTemps);
        };
    }

    private record Elevation(BlockPos lightPos, BlockPos pos) {
    }

    private record RegionEntry(DepthTempData.TempRegion region, double distance, int minY, int maxY) {
    }
}

