/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.BlockAffectTempTrigger;
import com.momosoftworks.coldsweat.core.init.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;
import oshi.util.tuples.Triplet;

public class BlockTempModifier
extends TempModifier {
    protected static final double LOG_FACTOR = 0.52;
    Map<ChunkPos, ChunkAccess> chunks = new HashMap<ChunkPos, ChunkAccess>(16);
    Map<BlockTemp, Double> blockTempEffects = new HashMap<BlockTemp, Double>(128);
    Map<BlockPos, BlockState> stateCache = new HashMap<BlockPos, BlockState>(4096);
    List<Triplet<BlockPos, BlockTemp, Double>> triggers = new ArrayList<Triplet<BlockPos, BlockTemp, Double>>(128);

    public BlockTempModifier() {
    }

    public BlockTempModifier(int range) {
        if (range > 0) {
            this.getNBT().putInt("RangeOverride", range);
        }
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        this.blockTempEffects.clear();
        this.stateCache.clear();
        this.triggers.clear();
        Level level = entity.level();
        int range = this.getNBT().contains("RangeOverride", 3) ? this.getNBT().getInt("RangeOverride") : ConfigSettings.BLOCK_RANGE.get().intValue();
        BlockPos blockPos = entity.blockPosition();
        int entX = blockPos.getX();
        int entY = blockPos.getY();
        int entZ = blockPos.getZ();
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        boolean shouldTickAdvancements = this.getTicksExisted() % 20 == 0;
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                ChunkPos chunkPos = new ChunkPos(entX + x >> 4, entZ + z >> 4);
                ChunkAccess chunk = this.chunks.get(chunkPos);
                if (chunk == null) {
                    chunk = WorldHelper.getChunk((LevelAccessor)level, chunkPos);
                    this.chunks.put(chunkPos, chunk);
                }
                if (chunk == null) continue;
                block2: for (int y = -range; y < range; ++y) {
                    Collection<BlockTemp> blockTemps;
                    blockpos.set(entX + x, entY + y, entZ + z);
                    BlockState state = this.stateCache.get(blockpos);
                    if (state == null) {
                        LevelChunkSection section = WorldHelper.getChunkSection(chunk, blockpos.getY());
                        state = section.getBlockState(blockpos.getX() & 0xF, blockpos.getY() & 0xF, blockpos.getZ() & 0xF);
                        this.stateCache.put(blockpos.immutable(), state);
                    }
                    if (state.isAir() || (blockTemps = BlockTempRegistry.getBlockTempsFor(state)).isEmpty() || blockTemps.size() == 1 && blockTemps.contains(BlockTempRegistry.DEFAULT_BLOCK_TEMP) || !BlockTempModifier.areAnyBlockTempsInRange(this.blockTempEffects, blockTemps)) continue;
                    Vec3 pos = Vec3.atCenterOf((Vec3i)blockpos);
                    Vec3 playerClosest = WorldHelper.getClosestPointOnEntity(entity, pos);
                    int[] blocks = new int[1];
                    Vec3 ray = pos.subtract(playerClosest);
                    Direction direction = Direction.getNearest((double)ray.x, (double)ray.y, (double)ray.z);
                    WorldHelper.forBlocksInRay(playerClosest, pos, level, chunk, this.stateCache, (rayState, bpos) -> {
                        if (!bpos.equals((Object)blockpos) && WorldHelper.isSpreadBlocked((LevelAccessor)level, rayState, bpos, direction, direction)) {
                            blocks[0] = blocks[0] + 1;
                        }
                    }, 3);
                    double distance = CSMath.getDistance(playerClosest, pos);
                    for (BlockTemp blockTemp : blockTemps) {
                        if (!blockTemp.isValid(level, (BlockPos)blockpos, state)) continue;
                        double temperature = blockTemp.getTemperature(level, entity, state, (BlockPos)blockpos, distance);
                        double tempToAdd = blockTemp.fade() ? CSMath.blend(temperature, 0.0, distance, 0.5, blockTemp.range()) : temperature;
                        double blockTempTotal = this.blockTempEffects.getOrDefault(blockTemp, 0.0);
                        if (blockTemp.logarithmic()) {
                            newTotal = Math.pow(Math.pow(blockTempTotal, 1.923076923076923) + tempToAdd, 0.52);
                            double delta = newTotal - blockTempTotal;
                            this.blockTempEffects.put(blockTemp, CSMath.clamp(blockTempTotal + (delta /= (double)(blocks[0] + 1)), blockTemp.minEffect(), blockTemp.maxEffect()));
                        } else {
                            newTotal = blockTempTotal + (tempToAdd /= (double)(blocks[0] + 1));
                            this.blockTempEffects.put(blockTemp, CSMath.clamp(newTotal, blockTemp.minEffect(), blockTemp.maxEffect()));
                        }
                        if (!shouldTickAdvancements) continue block2;
                        this.triggers.add((Triplet<BlockPos, BlockTemp, Double>)new Triplet((Object)blockpos, (Object)blockTemp, (Object)distance));
                        continue block2;
                    }
                }
            }
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (shouldTickAdvancements) {
                for (Triplet<BlockPos, BlockTemp, Double> trigger : this.triggers) {
                    ((BlockAffectTempTrigger)((Object)ModAdvancementTriggers.BLOCK_AFFECTS_TEMP.value())).trigger(player, (BlockPos)trigger.getA(), (Double)trigger.getC(), this.blockTempEffects.get(trigger.getB()));
                }
            }
        }
        while (this.chunks.size() >= 16) {
            this.chunks.remove(this.chunks.keySet().iterator().next());
        }
        return temp -> {
            for (Map.Entry<BlockTemp, Double> effect : this.blockTempEffects.entrySet()) {
                BlockTemp be = effect.getKey();
                double min = be.minTemperature();
                double max = be.maxTemperature();
                if (!CSMath.betweenInclusive(temp, min, max)) continue;
                double effectValue = effect.getValue();
                temp = CSMath.clamp(temp + effectValue, min, max);
            }
            return temp;
        };
    }

    private static boolean areAnyBlockTempsInRange(Map<BlockTemp, Double> blockTempEffects, Collection<BlockTemp> blockTemps) {
        boolean isInTempRange = blockTempEffects.isEmpty();
        if (!isInTempRange) {
            for (Map.Entry<BlockTemp, Double> entry : blockTempEffects.entrySet()) {
                BlockTemp key = entry.getKey();
                Double value = entry.getValue();
                if (blockTemps.contains(key) && !CSMath.betweenInclusive(value, key.minEffect(), key.maxEffect())) continue;
                isInTempRange = true;
                break;
            }
        }
        return isInTempRange;
    }
}

