/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.alcatrazescapee.primalwinter.ForgePrimalWinter;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.Tags;

public class BiomeTempModifier
extends TempModifier {
    public BiomeTempModifier() {
        this(16);
    }

    public BiomeTempModifier(int samples) {
        this.getNBT().putInt("Samples", samples);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        int samples = this.getNBT().getInt("Samples");
        double worldTemp = 0.0;
        Level level = entity.level();
        DimensionType dimension = level.dimensionType();
        BlockPos entPos = entity.blockPosition();
        Pair<Double, Double> structureTemp = BiomeTempModifier.getStructureTemp(entity.level(), entity.blockPosition());
        if (structureTemp.getFirst() != null) {
            return temp -> (Double)structureTemp.getFirst();
        }
        DimensionTempData dimTempOverride = ConfigSettings.DIMENSION_TEMPS.get(level.registryAccess()).get(level.dimensionTypeRegistration());
        if (dimTempOverride != null) {
            return temp -> temp + dimTempOverride.getTemperature();
        }
        DimensionTempData dimTempOffset = ConfigSettings.DIMENSION_OFFSETS.get(level.registryAccess()).get(level.dimensionTypeRegistration());
        double dimOffset = dimTempOffset != null ? dimTempOffset.getTemperature() : 0.0;
        int biomeCount = 0;
        for (BlockPos blockPos : dimension.hasCeiling() ? WorldHelper.getPositionCube(entPos, (int)Math.sqrt(samples), 10) : WorldHelper.getPositionGrid(entPos, samples, 10)) {
            Holder holder = level.getBiomeManager().getBiome(blockPos);
            if (holder.is(Tags.Biomes.IS_UNDERGROUND) || holder.unwrapKey().isEmpty()) continue;
            if (!dimension.hasCeiling() && !level.dimensionType().hasFixedTime()) {
                BiomeTempData biomeTempData = ConfigSettings.BIOME_TEMPS.get(level.registryAccess()).get(holder);
                if (CSMath.getIfNotNull(biomeTempData, BiomeTempData::isDisabled, false).booleanValue()) continue;
                double biomeTemp = WorldHelper.getBiomeTemperature((LevelAccessor)level, (Holder<Biome>)holder);
                if (CompatManager.isPrimalWinterLoaded() && biomeTempData != null) {
                    boolean isWinterBiome = ForgePrimalWinter.CONFIG.isWinterBiome((ResourceKey)holder.unwrapKey().get());
                    boolean isWinterDimension = ForgePrimalWinter.CONFIG.isWinterDimension(level.dimension());
                    if (isWinterBiome && isWinterDimension) {
                        biomeTemp = Math.min(biomeTemp, biomeTemp / 2.0);
                    }
                }
                worldTemp += biomeTemp;
            } else {
                worldTemp += CSMath.averagePair(WorldHelper.getBiomeTemperatureRange((LevelAccessor)level, (Holder<Biome>)holder));
            }
            ++biomeCount;
        }
        worldTemp /= (double)Math.max(1, biomeCount);
        if (!dimension.hasCeiling() && level.isRaining()) {
            long time = level.getDayTime();
            double overcastTemp = ConfigSettings.OVERCAST_TEMP_OFFSET.get() * (double)level.getRainLevel(1.0f);
            worldTemp += CSMath.blend(0.0, overcastTemp, (double)Math.abs(6000L - time), 6000.0, 0.0);
        }
        double finalWorldTemp = worldTemp += ((Double)structureTemp.getSecond()).doubleValue();
        return temp -> temp + finalWorldTemp + dimOffset;
    }

    public static Pair<Double, Double> getStructureTemp(Level level, BlockPos pos) {
        Optional<Holder<Structure>> structure = WorldHelper.getStructureAt(level, pos);
        if (structure.isEmpty()) {
            return Pair.of(null, (Object)0.0);
        }
        Double strucTemp = CSMath.getIfNotNull(ConfigSettings.STRUCTURE_TEMPS.get(level.registryAccess()).get(structure.get()), StructureTempData::getTemperature, null);
        Double strucOffset = CSMath.getIfNotNull(ConfigSettings.STRUCTURE_OFFSETS.get(level.registryAccess()).get(structure.get()), StructureTempData::getTemperature, 0.0);
        return Pair.of((Object)strucTemp, (Object)strucOffset);
    }
}

