/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.event.HandleTempEffects;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

public class HeatVignetteEffect
extends TempEffect {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/haze.png");

    public HeatVignetteEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    protected void setupRender(float opacity, float tickTime) {
        float vignetteBrightness = opacity + ((float)Math.sin((double)(tickTime + 3.0f) / 3.18306181683261) / 5.0f - 0.2f) * opacity;
        RenderSystem.setShaderColor((float)0.231f, (float)0.0f, (float)0.0f, (float)vignetteBrightness);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void vignette(RenderGuiLayerEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!this.test((Entity)player)) {
            return;
        }
        if (HandleTempEffects.isPlayerImmune((Player)player)) {
            return;
        }
        float tickTime = (float)player.tickCount + event.getPartialTick().getGameTimeDeltaPartialTick(true);
        float blendTemp = (float)Overlays.BLEND_BODY_TEMP;
        if (event.getName() == VanillaGuiLayers.CAMERA_OVERLAYS && blendTemp > 0.0f && HandleTempEffects.Client.HOT_IMMUNITY < 1.0) {
            float resistance = (float)CSMath.blend(1.0, 0.0, HandleTempEffects.Client.HOT_IMMUNITY, 0.0, 1.0);
            float opacity = CSMath.blend(0.0f, 1.0f, blendTemp, this.bounds().min(), this.bounds().max()) * resistance;
            if ((opacity = (float)((double)opacity * ConfigSettings.HEATSTROKE_BORDER_OPACITY.get())) == 0.0f) {
                return;
            }
            float width = Minecraft.getInstance().getWindow().getWidth();
            float scale = (float)Minecraft.getInstance().getWindow().getGuiScale();
            float height = Minecraft.getInstance().getWindow().getHeight();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            this.setupRender(opacity, tickTime);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(0.0f, height / scale, -90.0f).setUv(0.0f, 1.0f);
            bufferbuilder.addVertex(width / scale, height / scale, -90.0f).setUv(1.0f, 1.0f);
            bufferbuilder.addVertex(width / scale, 0.0f, -90.0f).setUv(1.0f, 0.0f);
            bufferbuilder.addVertex(0.0f, 0.0f, -90.0f).setUv(0.0f, 0.0f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
        }
    }

    @Override
    public boolean isClient() {
        return true;
    }
}

