/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.event.HandleTempEffects;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

public class HeatFogEffect
extends TempEffect {
    public HeatFogEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    private void renderHeatFogA(ViewportEvent.RenderFog event) {
        this.renderHeatFog((ViewportEvent)event);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    private void renderHeatFogB(ViewportEvent.ComputeFogColor event) {
        this.renderHeatFog((ViewportEvent)event);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderHeatFog(ViewportEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!this.test((Entity)player)) {
            return;
        }
        if (!(event instanceof ViewportEvent.RenderFog) && !(event instanceof ViewportEvent.ComputeFogColor)) {
            return;
        }
        if (HandleTempEffects.isPlayerImmune((Player)player)) {
            return;
        }
        double fogDistance = ConfigSettings.HEATSTROKE_FOG_DISTANCE.get();
        if (fogDistance >= 64.0) {
            return;
        }
        if (fogDistance < Double.POSITIVE_INFINITY && Overlays.BLEND_BODY_TEMP >= 50.0 && HandleTempEffects.Client.HOT_IMMUNITY < 1.0) {
            float tempWithResistance = (float)CSMath.blend(Overlays.BLEND_BODY_TEMP, 50.0, HandleTempEffects.Client.HOT_IMMUNITY, 0.0, 1.0);
            if (event instanceof ViewportEvent.RenderFog) {
                ViewportEvent.RenderFog fog = (ViewportEvent.RenderFog)event;
                if (fogDistance > (double)fog.getFarPlaneDistance()) {
                    return;
                }
                fog.setFarPlaneDistance(CSMath.blend(fog.getFarPlaneDistance(), (float)fogDistance, tempWithResistance, 50.0f, 90.0f));
                fog.setNearPlaneDistance(CSMath.blend(fog.getNearPlaneDistance(), (float)(fogDistance * 0.3), tempWithResistance, 50.0f, 90.0f));
                fog.setCanceled(true);
            } else {
                ViewportEvent.ComputeFogColor fogColor = (ViewportEvent.ComputeFogColor)event;
                fogColor.setRed(CSMath.blend(fogColor.getRed(), 0.01f, tempWithResistance, 50.0f, 90.0f));
                fogColor.setGreen(CSMath.blend(fogColor.getGreen(), 0.01f, tempWithResistance, 50.0f, 90.0f));
                fogColor.setBlue(CSMath.blend(fogColor.getBlue(), 0.05f, tempWithResistance, 50.0f, 90.0f));
            }
        }
    }

    @Override
    public boolean isClient() {
        return true;
    }
}

