/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.mojang.blaze3d.shaders.Uniform;
import com.momosoftworks.coldsweat.api.event.vanilla.RenderLevelEvent;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.client.renderer.PostProcessShaderManager;
import com.momosoftworks.coldsweat.common.event.HandleTempEffects;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;

public class HeatBlurEffect
extends TempEffect {
    public HeatBlurEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderBlur(RenderLevelEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!this.test((Entity)player)) {
            return;
        }
        if (HandleTempEffects.isPlayerImmune((Player)player)) {
            return;
        }
        double blurMultiplier = ConfigSettings.HEATSTROKE_BLUR_AMOUNT.get();
        if (blurMultiplier == 0.0) {
            return;
        }
        PostProcessShaderManager shaderManager = PostProcessShaderManager.getInstance();
        if (ConfigSettings.DISTORTION_EFFECTS.get().booleanValue() && Overlays.BLEND_BODY_TEMP >= 50.0 && HandleTempEffects.Client.HOT_IMMUNITY < 1.0) {
            Uniform blurRadius;
            float blur = (float)CSMath.blend(0.0, 12.0, Overlays.BLEND_BODY_TEMP, (double)this.bounds().min(), (double)this.bounds().max());
            blur = (float)CSMath.blend((double)blur, 0.0, HandleTempEffects.Client.HOT_IMMUNITY, 0.0, 1.0);
            blur = (float)((double)blur * blurMultiplier);
            if (!shaderManager.hasEffect("heat_blur")) {
                shaderManager.loadEffect("heat_blur", PostProcessShaderManager.BLOBS);
            }
            if ((blurRadius = shaderManager.getPostPasses("heat_blur").get(0).getEffect().getUniform("Radius")) != null) {
                blurRadius.set(blur);
            }
        } else if (shaderManager.hasEffect("heat_blur")) {
            shaderManager.closeEffect("heat_blur");
        }
        shaderManager.process(event.getPartialTick());
    }

    @Override
    public boolean isClient() {
        return true;
    }
}

