/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.event.HandleTempEffects;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

public class FreezeShiverEffect
extends TempEffect {
    public FreezeShiverEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void shiverCamera(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!this.test((Entity)player)) {
            return;
        }
        if (HandleTempEffects.isPlayerImmune((Player)player)) {
            return;
        }
        if (!Minecraft.getInstance().isPaused() && ConfigSettings.DISTORTION_EFFECTS.get().booleanValue() && Overlays.BLEND_BODY_TEMP <= -50.0 && HandleTempEffects.Client.COLD_IMMUNITY < 1.0) {
            double tickTime = (double)player.tickCount + event.getPartialTick();
            float shiverIntensity = (float)CSMath.blend(0.0, (Math.sin(tickTime / 10.0) + 1.0) * (double)0.03f + (double)0.01f, Overlays.BLEND_BODY_TEMP, (double)this.bounds().min(), (double)this.bounds().max());
            shiverIntensity = (float)((double)shiverIntensity * ConfigSettings.SHIVER_INTENSITY.get());
            shiverIntensity *= Minecraft.getInstance().getTimer().getRealtimeDeltaTicks() * 10.0f;
            shiverIntensity = (float)CSMath.blend((double)shiverIntensity, 0.0, HandleTempEffects.Client.COLD_IMMUNITY, 0.0, 1.0);
            float shiverRotation = (float)(Math.sin(tickTime * 2.5) * (double)shiverIntensity);
            player.setYRot(player.getYRot() + shiverRotation);
        }
    }

    @Override
    public boolean isClient() {
        return true;
    }
}

