/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class FreezeMoveSpeedEffect
extends TempEffect {
    public FreezeMoveSpeedEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        if (!this.test((Entity)event.getEntity())) {
            return;
        }
        if (EntityTempManager.isPeacefulMode(this.entity())) {
            return;
        }
        float temp = (float)this.getTemperature();
        if (temp < -50.0f) {
            float minMoveMultiplier;
            double movementReduction = ConfigSettings.COLD_MOVEMENT_SLOWDOWN.get();
            double movementSpeed = 1.0 - movementReduction;
            if (movementSpeed == 1.0 || this.entity().hasEffect(ModEffects.ICE_RESISTANCE) || this.entity().hasEffect(ModEffects.GRACE)) {
                return;
            }
            if (!this.entity().isFallFlying() && (minMoveMultiplier = (float)CSMath.blend(this.entity().onGround() ? movementSpeed : movementSpeed * 1.25, 1.0, Temperature.get(this.entity(), Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0)) != 1.0f) {
                float moveSpeed = CSMath.blend(1.0f, minMoveMultiplier, temp, this.bounds().min(), this.bounds().max());
                this.entity().setDeltaMovement(this.entity().getDeltaMovement().multiply((double)moveSpeed, 1.0, (double)moveSpeed));
            }
        }
    }

    @Override
    public boolean isClient() {
        return false;
    }
}

