/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class FreezeMineSpeedEffect
extends TempEffect {
    public FreezeMineSpeedEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @SubscribeEvent
    public void onPlayerMine(PlayerEvent.BreakSpeed event) {
        if (!this.test((Entity)event.getEntity())) {
            return;
        }
        Player player = event.getEntity();
        if (EntityTempManager.isPeacefulMode((LivingEntity)player)) {
            return;
        }
        float miningSpeed = 1.0f - ConfigSettings.COLD_MINING_IMPAIRMENT.get().floatValue();
        if (miningSpeed == 1.0f || player.hasEffect(ModEffects.ICE_RESISTANCE) || player.hasEffect(ModEffects.GRACE)) {
            return;
        }
        float temp = (float)this.getTemperature();
        float minMiningSpeed = (float)CSMath.blend((double)miningSpeed, 1.0, Temperature.get((LivingEntity)player, Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0);
        event.setNewSpeed(event.getNewSpeed() * CSMath.blend(1.0f, minMiningSpeed, temp, this.bounds().min(), this.bounds().max()));
    }

    @Override
    public boolean isClient() {
        return false;
    }
}

