/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;

public class FreezeKnockbackEffect
extends TempEffect {
    public FreezeKnockbackEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @SubscribeEvent
    public void onPlayerKnockback(LivingKnockBackEvent event) {
        float tempResistance;
        if (!this.test((Entity)event.getEntity().getLastHurtByMob())) {
            return;
        }
        if (EntityTempManager.isPeacefulMode(this.entity())) {
            return;
        }
        float knockbackReduction = ConfigSettings.COLD_KNOCKBACK_REDUCTION.get().floatValue();
        if (knockbackReduction <= 0.0f || this.entity().hasEffect(ModEffects.ICE_RESISTANCE) || this.entity().hasEffect(ModEffects.GRACE)) {
            return;
        }
        float temp = (float)this.getTemperature();
        if (temp < -50.0f && (tempResistance = (float)Temperature.get(this.entity(), Temperature.Trait.COLD_RESISTANCE)) != 1.0f) {
            event.setStrength(event.getStrength() * CSMath.blend(1.0f, tempResistance, temp, this.bounds().min(), this.bounds().max()) * knockbackReduction);
        }
    }

    @Override
    public boolean isClient() {
        return false;
    }
}

