/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.event.vanilla.RenderHeartEvent;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;

public class FreezeHeartsEffect
extends TempEffect {
    private static final ResourceLocation HEART_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/hearts_frozen.png");
    private int heartIndex = 0;

    public FreezeHeartsEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderHeart(RenderHeartEvent event) {
        int v;
        int u;
        if (!this.test((Entity)Minecraft.getInstance().player)) {
            return;
        }
        if (!ConfigSettings.SHOW_FROZEN_HEALTH.get().booleanValue()) {
            return;
        }
        Gui.HeartType heartType = event.getHeartType();
        boolean halfHeart = event.isHalfHeart();
        int x = event.getX();
        int y = event.getY();
        if (heartType == Gui.HeartType.CONTAINER) {
            ++this.heartIndex;
        }
        double heartsFreezePercentage = ConfigSettings.HEARTS_FREEZING_PERCENTAGE.get();
        if (this.entity() == null) {
            return;
        }
        if (heartsFreezePercentage == 0.0 || this.entity().hasEffect(ModEffects.GRACE)) {
            return;
        }
        if (this.entity().hasEffect(ModEffects.ICE_RESISTANCE)) {
            return;
        }
        double temp = Overlays.BLEND_BODY_TEMP;
        float maxHealth = this.entity().getMaxHealth();
        boolean isHardcore = this.entity().level().getLevelData().isHardcore();
        float maxFrozenHealth = (float)CSMath.blend((double)maxHealth * heartsFreezePercentage, 0.0, Temperature.get(this.entity(), Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0);
        if (maxFrozenHealth == 0.0f) {
            return;
        }
        int frozenHealth = (int)Math.round(CSMath.blend(0.0, (double)maxHealth * heartsFreezePercentage, temp, (double)this.bounds().min(), (double)this.bounds().max()));
        int frozenHearts = Math.round((float)frozenHealth / 2.0f);
        boolean partialFrozen = frozenHealth % 2 == 1 && this.heartIndex == frozenHearts;
        int n = u = isHardcore ? 7 : 0;
        int n2 = partialFrozen ? (halfHeart ? 21 : 14) : (v = halfHeart ? 7 : 0);
        if (this.heartIndex <= frozenHearts) {
            if (heartType == Gui.HeartType.CONTAINER) {
                event.getGuiGraphics().blit(HEART_TEXTURE, x + 1, y + 1, 14.0f, (float)v, 7, 7, 21, 28);
            } else {
                event.getGuiGraphics().blit(HEART_TEXTURE, x + 1, y + 1, (float)u, (float)v, 7, 7, 21, 28);
            }
        }
    }

    @SubscribeEvent
    public void resetHeartIndex(RenderFrameEvent.Pre event) {
        this.heartIndex = 0;
    }

    @Override
    public boolean isClient() {
        return true;
    }
}

