/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModEffects;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;

public class FreezeHealingEffect
extends TempEffect {
    public FreezeHealingEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @SubscribeEvent
    public void onHeal(LivingHealEvent event) {
        float unfrozenHealth;
        if (!this.test((Entity)event.getEntity())) {
            return;
        }
        if (EntityTempManager.isPeacefulMode(this.entity())) {
            return;
        }
        double frozenHeartsPercentage = ConfigSettings.HEARTS_FREEZING_PERCENTAGE.get();
        if (frozenHeartsPercentage <= 0.0 || this.entity().hasEffect(ModEffects.ICE_RESISTANCE) || this.entity().hasEffect(ModEffects.GRACE)) {
            return;
        }
        float healing = event.getAmount();
        float temp = (float)this.getTemperature();
        if (temp < -50.0f && (unfrozenHealth = (float)CSMath.blend(1.0 - frozenHeartsPercentage, 1.0, Temperature.get(this.entity(), Temperature.Trait.COLD_RESISTANCE), 0.0, 1.0)) != 1.0f) {
            event.setAmount(CSMath.clamp(healing, 0.0f, (float)CSMath.ceil(this.entity().getMaxHealth() * CSMath.blend(unfrozenHealth, 1.0f, temp, this.bounds().min(), this.bounds().max())) - this.entity().getHealth()));
        }
    }

    @Override
    public boolean isClient() {
        return false;
    }
}

