/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.insulation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.util.math.CSMath;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class StaticInsulation
extends Insulation {
    public static final Codec<StaticInsulation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("cold").forGetter(StaticInsulation::getCold), (App)Codec.DOUBLE.fieldOf("heat").forGetter(StaticInsulation::getHeat)).apply((Applicative)instance, StaticInsulation::new));
    public static final StreamCodec<ByteBuf, StaticInsulation> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    private final double cold;
    private final double heat;

    public StaticInsulation(double cold, double heat) {
        this.cold = cold;
        this.heat = heat;
    }

    public StaticInsulation(Pair<? extends Number, ? extends Number> pair) {
        this(((Number)pair.getFirst()).doubleValue(), ((Number)pair.getSecond()).doubleValue());
    }

    @Override
    public double getCold() {
        return this.cold;
    }

    @Override
    public double getHeat() {
        return this.heat;
    }

    @Override
    public double getValue() {
        return this.cold + this.heat;
    }

    @Override
    public boolean isEmpty() {
        return this.cold == 0.0 && this.heat == 0.0;
    }

    @Override
    public List<Insulation> split() {
        int i;
        ArrayList<Insulation> insulation = new ArrayList<Insulation>();
        double cold = this.getCold();
        double heat = this.getHeat();
        double neutral = cold > 0.0 == heat > 0.0 ? CSMath.minAbs(cold, heat) : 0.0;
        cold -= neutral;
        heat -= neutral;
        for (i = 0; i < CSMath.ceil(Math.abs(cold) / 2.0); ++i) {
            double coldInsul = CSMath.minAbs(CSMath.shrink(cold, (double)(i * 2)), 2 * CSMath.sign(cold));
            insulation.add(new StaticInsulation(coldInsul, 0.0));
        }
        for (i = 0; i < CSMath.ceil(Math.abs(neutral)); ++i) {
            double neutralInsul = CSMath.minAbs(CSMath.shrink(neutral, (double)i), 1 * CSMath.sign(neutral));
            insulation.add(new StaticInsulation(neutralInsul, neutralInsul));
        }
        for (i = 0; i < CSMath.ceil(Math.abs(heat) / 2.0); ++i) {
            double heatInsul = CSMath.minAbs(CSMath.shrink(heat, (double)(i * 2)), 2 * CSMath.sign(heat));
            insulation.add(new StaticInsulation(0.0, heatInsul));
        }
        return insulation;
    }

    @Override
    public <T extends Insulation> T copy() {
        return (T)new StaticInsulation(this.cold, this.heat);
    }

    public String toString() {
        return "Insulation{cold=" + this.cold + ", heat=" + this.heat + "}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticInsulation)) return false;
        StaticInsulation insul = (StaticInsulation)obj;
        if (this.cold != insul.cold) return false;
        if (this.heat != insul.heat) return false;
        return true;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.putDouble("cold", this.cold);
        tag.putDouble("heat", this.heat);
        return tag;
    }

    public static StaticInsulation deserialize(CompoundTag tag) {
        return new StaticInsulation(tag.getDouble("cold"), tag.getDouble("heat"));
    }
}

