/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.event.core.registry;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.momosoftworks.coldsweat.data.codec.configuration.RemoveRegistryData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.util.math.RegistryMultiMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.Event;

public abstract class CreateRegistriesEvent
extends Event {
    RegistryAccess registryAccess;
    RegistryMultiMap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries;

    public CreateRegistriesEvent(RegistryAccess registryAccess, RegistryMultiMap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries) {
        this.registryAccess = registryAccess;
        this.registries = registries;
    }

    public RegistryAccess getRegistryAccess() {
        return this.registryAccess;
    }

    public RegistryMultiMap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> getRegistries() {
        return this.registries;
    }

    public <T extends ConfigData> Collection<Holder<T>> getRegistry(ResourceKey<? extends Registry<T>> key) {
        return this.registries.get(key);
    }

    public <T extends ConfigData> void addRegistry(ResourceKey<? extends Registry<T>> key, Holder<T> value) {
        this.registries.asMap().computeIfAbsent(key, k -> new LinkedHashSet()).add(value);
    }

    public <T extends ConfigData> void addRegistries(ResourceKey<? extends Registry<T>> key, Collection<Holder<T>> values) {
        this.registries.asMap().computeIfAbsent(key, k -> new LinkedHashSet()).addAll(values);
    }

    public static class Post
    extends CreateRegistriesEvent {
        public Post(RegistryAccess registryAccess, RegistryMultiMap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries) {
            super(registryAccess, registries);
        }
    }

    public static class Pre
    extends CreateRegistriesEvent {
        private Multimap<ResourceKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> removals;

        public Pre(RegistryAccess registryAccess, RegistryMultiMap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries, Multimap<ResourceKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> removals) {
            super(registryAccess, registries);
        }

        public Multimap<ResourceKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> getRegistryRemovals() {
            return ImmutableMultimap.copyOf(this.removals);
        }
    }
}

