/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.neoforge.create;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import java.util.function.UnaryOperator;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.HourGlassBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HourGlassBlock;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimeData;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimesManager;
import net.mehvahdjukaar.supplementaries.integration.neoforge.CreateCompatImpl;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class HourglassBehavior
implements MovementBehaviour {
    private HourglassTimeData sandData;
    private float progress;
    private float prevProgress;
    private ResourceLocation cachedTexture;

    public void tick(MovementContext context) {
        UnaryOperator rot = context.rotation;
        BlockState state = context.state;
        Direction dir = (Direction)state.getValue((Property)HourGlassBlock.FACING);
        Rotation rotation = CreateCompatImpl.isClockWise(rot, dir);
        CompoundTag com = context.blockEntityData;
        HourglassTimeData prevSandData = this.sandData = HourglassTimeData.EMPTY;
        NonNullList l = NonNullList.create();
        ContainerHelper.loadAllItems((CompoundTag)com, (NonNullList)l, (HolderLookup.Provider)context.world.registryAccess());
        if (l.isEmpty()) {
            return;
        }
        this.sandData = HourglassTimesManager.getInstance(context.world).getData(((ItemStack)l.get(0)).getItem());
        if (prevSandData != this.sandData && context.world.isClientSide) {
            this.cachedTexture = this.sandData.computeTexture((ItemStack)l.get(0), context.world);
        }
        this.progress = com.getFloat("Progress");
        this.prevProgress = com.getFloat("PrevProgress");
        if (!this.sandData.isEmpty()) {
            this.prevProgress = this.progress;
            if (rotation == Rotation.CLOCKWISE_90 && this.progress != 1.0f) {
                this.progress = Math.min(this.progress + this.sandData.getIncrement(), 1.0f);
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90 && this.progress != 0.0f) {
                this.progress = Math.max(this.progress - this.sandData.getIncrement(), 0.0f);
            }
        }
        com.remove("Progress");
        com.remove("PrevProgress");
        com.putFloat("Progress", this.progress);
        com.putFloat("PrevProgress", this.prevProgress);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        float partialTicks = 1.0f;
        if (this.sandData.isEmpty()) {
            return;
        }
        Vec3 v = context.position;
        if (v == null) {
            v = new Vec3(0.0, 0.0, 0.0);
        }
        BlockPos pos = BlockPos.containing((Position)v);
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)context.world, (BlockPos)pos);
        float h = Mth.lerp((float)partialTicks, (float)this.prevProgress, (float)this.progress);
        Direction dir = (Direction)context.state.getValue((Property)HourGlassBlock.FACING);
        HourGlassBlockTileRenderer.renderSand(matrices.getModelViewProjection(), buffer, light, this.cachedTexture, h, dir);
    }
}

