/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import org.jetbrains.annotations.Nullable;

public final class PresentAddress
implements TooltipProvider {
    private static final Component PUBLIC = Component.translatable((String)"message.supplementaries.present.public").withStyle(ChatFormatting.GRAY);
    public static final Codec<PresentAddress> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("recipient").forGetter(PresentAddress::recipient), (App)Codec.STRING.fieldOf("sender").forGetter(PresentAddress::sender), (App)Codec.STRING.fieldOf("description").forGetter(PresentAddress::description)).apply((Applicative)instance, PresentAddress::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PresentAddress> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PresentAddress::recipient, (StreamCodec)ByteBufCodecs.STRING_UTF8, PresentAddress::sender, (StreamCodec)ByteBufCodecs.STRING_UTF8, PresentAddress::description, PresentAddress::new);
    private final String recipient;
    private final String sender;
    private final String description;
    @Nullable
    private final Component recipientComp;
    @Nullable
    private final Component senderComp;

    private PresentAddress(String recipient, String sender, String description) {
        this.recipient = recipient;
        this.sender = sender;
        this.description = description;
        this.recipientComp = PresentAddress.getRecipientMessage(recipient);
        this.senderComp = PresentAddress.getSenderMessage(sender);
    }

    @Nullable
    public static PresentAddress of(String recipient, String sender, String description) {
        if (recipient.isEmpty() && sender.isEmpty()) {
            return null;
        }
        return new PresentAddress(recipient, sender, description);
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        boolean isPacked = false;
        if (this.senderComp != null) {
            tooltipAdder.accept(this.senderComp);
            isPacked = true;
        }
        if (this.recipientComp != null) {
            tooltipAdder.accept(this.recipientComp);
            isPacked = true;
        }
        if (!isPacked) {
            tooltipAdder.accept(PUBLIC);
        }
    }

    @Nullable
    private static MutableComponent getSenderMessage(String sender) {
        if (sender.isEmpty()) {
            return null;
        }
        return Component.translatable((String)"message.supplementaries.present.from", (Object[])new Object[]{sender}).withStyle(ChatFormatting.GRAY);
    }

    @Nullable
    private static MutableComponent getRecipientMessage(String recipient) {
        if (recipient.isEmpty()) {
            return null;
        }
        if (recipient.equalsIgnoreCase("@e")) {
            return Component.translatable((String)"message.supplementaries.present.public").withStyle(ChatFormatting.GRAY);
        }
        return Component.translatable((String)"message.supplementaries.present.to", (Object[])new Object[]{recipient}).withStyle(ChatFormatting.GRAY);
    }

    @Nullable
    public String recipient() {
        return this.recipient;
    }

    @Nullable
    public String sender() {
        return this.sender;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public boolean isPublic() {
        return this.recipient.equalsIgnoreCase("@e");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PresentAddress)) {
            return false;
        }
        PresentAddress that = (PresentAddress)o;
        return Objects.equals(this.recipient, that.recipient) && Objects.equals(this.sender, that.sender) && Objects.equals(this.description, that.description) && Objects.equals(this.recipientComp, that.recipientComp) && Objects.equals(this.senderComp, that.senderComp);
    }

    public int hashCode() {
        return Objects.hash(this.recipient, this.sender, this.description, this.recipientComp, this.senderComp);
    }
}

