/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapsHandler;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.Structure;

public class StructureMapCommand {
    private static final DynamicCommandExceptionType ERROR_STRUCTURE_INVALID = new DynamicCommandExceptionType(object -> Component.translatable((String)"commands.locate.structure.invalid", (Object[])new Object[]{object}));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext context) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"structure_map").requires(cs -> cs.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"structure", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.STRUCTURE)).executes(c -> StructureMapCommand.giveMap((CommandContext<CommandSourceStack>)c, 2))).then(Commands.argument((String)"zoom", (ArgumentType)IntegerArgumentType.integer()).executes(c -> StructureMapCommand.giveMap((CommandContext<CommandSourceStack>)c, IntegerArgumentType.getInteger((CommandContext)c, (String)"zoom")))));
    }

    public static int giveMap(CommandContext<CommandSourceStack> context, int zoom) throws CommandSyntaxException {
        ItemStack item;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        ResourceOrTagKeyArgument.Result structure = ResourceOrTagKeyArgument.getResourceOrTagKey(context, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID);
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        HolderSet<Structure> holderSet = StructureMapCommand.getHolders((ResourceOrTagKeyArgument.Result<Structure>)structure, (Registry<Structure>)registry).orElseThrow(() -> ERROR_STRUCTURE_INVALID.create((Object)structure.asPrintable()));
        ServerPlayer p = source.getPlayer();
        if (p != null && !(item = AdventurerMapsHandler.createMapOrQuill(level, p.getOnPos(), holderSet, 150, true, zoom, null, null, 0)).isEmpty()) {
            p.addItem(item);
        }
        return 0;
    }

    private static Optional<? extends HolderSet<Structure>> getHolders(ResourceOrTagKeyArgument.Result<Structure> structure, Registry<Structure> structureRegistry) {
        Objects.requireNonNull(structureRegistry);
        return (Optional)structure.unwrap().map(res -> structureRegistry.getHolder(res).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})), arg_0 -> structureRegistry.getTag(arg_0));
    }
}

