/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.supplementaries.common.block.blocks.SafeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.OpeneableContainerBlockEntity;
import net.mehvahdjukaar.supplementaries.common.inventories.VariableSizeContainerMenu;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SackBlockTile
extends OpeneableContainerBlockEntity {
    public SackBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.SACK_TILE.get(), pos, state, 27);
    }

    public static int getUnlockedSlots() {
        return CommonConfigs.Functional.SACK_SLOTS.get();
    }

    @Override
    public int getContainerSize() {
        return SackBlockTile.getUnlockedSlots();
    }

    public Component getDefaultName() {
        return Component.translatable((String)"gui.supplementaries.sack");
    }

    @Override
    protected void playOpenSound(BlockState state) {
        double d0 = (double)this.worldPosition.getX() + 0.5;
        double d1 = (double)this.worldPosition.getY() + 1.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5;
        this.level.playSound(null, d0, d1, d2, ModSounds.SACK_OPEN.get(), SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.95f);
    }

    @Override
    protected void playCloseSound(BlockState state) {
        double d0 = (double)this.worldPosition.getX() + 0.5;
        double d1 = (double)this.worldPosition.getY() + 1.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5;
        this.level.playSound(null, d0, d1, d2, ModSounds.SACK_OPEN.get(), SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.8f);
    }

    @Override
    protected void updateBlockState(BlockState state, boolean open) {
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)SafeBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv) {
        if (inv.player.isSpectator()) {
            return null;
        }
        return new VariableSizeContainerMenu(id, inv, (Container)this, this.getContainerSize());
    }

    public boolean isSlotUnlocked(int ind) {
        return ind < this.getContainerSize();
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.isSlotUnlocked(index) && MiscUtils.isAllowedInShulker(stack, this.getLevel());
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return this.isSlotUnlocked(index);
    }
}

