/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.DynamicRenderedItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBuntingBlock;
import net.mehvahdjukaar.supplementaries.common.items.BuntingItem;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BuntingBlockTile
extends DynamicRenderedItemDisplayTile {
    public static final ModelDataKey<DyeColor> NORTH_BUNTING = new ModelDataKey(DyeColor.class);
    public static final ModelDataKey<DyeColor> SOUTH_BUNTING = new ModelDataKey(DyeColor.class);
    public static final ModelDataKey<DyeColor> EAST_BUNTING = new ModelDataKey(DyeColor.class);
    public static final ModelDataKey<DyeColor> WEST_BUNTING = new ModelDataKey(DyeColor.class);
    private final Map<Direction, DyeColor> buntings = new EnumMap<Direction, DyeColor>(Direction.class);

    public BuntingBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.BUNTING_TILE.get(), pos, state, 4);
    }

    public Map<Direction, DyeColor> getBuntings() {
        return this.buntings;
    }

    public void updateClientVisualsOnLoad() {
        this.buntings.clear();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            DyeColor color;
            ItemStack stack = this.getItem(d.get2DDataValue());
            if (!(stack.getItem() instanceof BuntingItem) || (color = BuntingItem.getColor(stack)) == null) continue;
            this.buntings.put(d, color);
        }
        if (this.buntings.isEmpty()) {
            // empty if block
        }
        this.requestModelReload();
    }

    public void updateTileOnInventoryChanged() {
        BlockState state = this.getBlockState();
        if (this.isEmpty()) {
            this.level.setBlockAndUpdate(this.worldPosition, RopeBuntingBlock.toRope(state));
        } else {
            BlockState state2 = state;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                EnumProperty<ModBlockProperties.Bunting> prop = RopeBuntingBlock.HORIZONTAL_FACING_TO_PROPERTY_MAP.get(dir);
                ModBlockProperties.Bunting old = (ModBlockProperties.Bunting)((Object)state2.getValue(prop));
                boolean isEmpty = this.getItem(dir.get2DDataValue()).isEmpty();
                state2 = (BlockState)state2.setValue(prop, (Comparable)((Object)(isEmpty ? (old == ModBlockProperties.Bunting.NONE ? ModBlockProperties.Bunting.NONE : ModBlockProperties.Bunting.ROPE) : ModBlockProperties.Bunting.BUNTING)));
            }
            if (state != state2) {
                this.level.setBlockAndUpdate(this.worldPosition, state2);
            }
        }
    }

    public boolean needsToUpdateClientWhenChanged() {
        return false;
    }

    public boolean isNeverFancy() {
        return ClientConfigs.Blocks.FAST_BUNTINGS.get();
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        super.addExtraModelData(builder);
        builder.with(NORTH_BUNTING, (Object)this.buntings.getOrDefault(Direction.NORTH, null));
        builder.with(SOUTH_BUNTING, (Object)this.buntings.getOrDefault(Direction.SOUTH, null));
        builder.with(EAST_BUNTING, (Object)this.buntings.getOrDefault(Direction.EAST, null));
        builder.with(WEST_BUNTING, (Object)this.buntings.getOrDefault(Direction.WEST, null));
    }

    protected boolean getFancyDistance(Vec3 cameraPos) {
        LOD lod = new LOD(cameraPos, this.getBlockPos());
        return lod.isNear();
    }

    public Component getDefaultName() {
        return Component.translatable((String)"item.supplementaries.bunting");
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return stack.getItem() instanceof BuntingItem && this.getItem(index).isEmpty() && RopeBuntingBlock.canSupportBunting(this.getBlockState(), index);
    }

    public boolean canTakeItem(Container container, int i, ItemStack itemStack) {
        return false;
    }

    public boolean canOpen(Player player) {
        return false;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return null;
    }

    public boolean rotateBuntings(BlockState state, Rotation rotation) {
        HashMap<Direction, ItemStack> newMap = new HashMap<Direction, ItemStack>();
        for (Direction dir2 : Direction.Plane.HORIZONTAL) {
            ItemStack stack2 = this.getItem(dir2.get2DDataValue());
            if (stack2.isEmpty()) continue;
            Direction newDir = rotation.rotate(dir2);
            if (RopeBuntingBlock.canSupportBunting(state, newDir.get2DDataValue())) {
                newMap.put(newDir, stack2);
                continue;
            }
            return false;
        }
        if (!newMap.isEmpty()) {
            this.clearContent();
            newMap.forEach((dir, stack) -> this.setItem(dir.get2DDataValue(), (ItemStack)stack));
            return true;
        }
        return false;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        BlockState state = this.getBlockState();
        if (((Boolean)state.getValue((Property)RopeBuntingBlock.FLIP_TILE)).booleanValue() && this.level != null) {
            this.rotateBuntings(state, Rotation.CLOCKWISE_90);
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)RopeBuntingBlock.FLIP_TILE, (Comparable)Boolean.valueOf(false)));
        }
        ListTag listTag = tag.getList("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.getCompound(i);
            CompoundTag nbt = compoundTag.getCompound("tag");
            if (nbt.isEmpty()) continue;
            int j = compoundTag.getByte("Slot") & 0xFF;
            DyeColor dye = DyeColor.byName((String)nbt.getString("Color"), (DyeColor)DyeColor.WHITE);
            this.getItem(j).set(DataComponents.BASE_COLOR, (Object)dye);
        }
    }
}

