/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.placeable_book;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookType;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SuppAdditionalPlacement;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendBookDataPacket;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceableBookManager
extends SimpleJsonResourceReloadListener {
    private static final SidedInstance<PlaceableBookManager> INSTANCES = SidedInstance.of(PlaceableBookManager::new);
    private final MapRegistry<BookType> books = new MapRegistry("placeable_books");
    private final Multimap<Item, BookType> itemToBooks = HashMultimap.create();
    private final HolderLookup.Provider registryAccess;
    private final SuppAdditionalPlacement horizontalPlacement;
    private final SuppAdditionalPlacement verticalPlacement;

    public PlaceableBookManager(HolderLookup.Provider registryAccess) {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "placeable_books");
        this.registryAccess = registryAccess;
        INSTANCES.set(registryAccess, (Object)this);
        this.horizontalPlacement = new SuppAdditionalPlacement(ModRegistry.BOOK_PILE_H.get());
        this.verticalPlacement = new SuppAdditionalPlacement(ModRegistry.BOOK_PILE.get());
    }

    public static PlaceableBookManager getInstance(HolderLookup.Provider ra) {
        return (PlaceableBookManager)((Object)INSTANCES.get(ra));
    }

    public static PlaceableBookManager getInstance(@NotNull Level level) {
        Preconditions.checkNotNull((Object)level);
        return PlaceableBookManager.getInstance((HolderLookup.Provider)level.registryAccess());
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.books.clear();
        RegistryOps ops = ForgeHelper.conditionalOps((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.registryAccess, (SimplePreparableReloadListener)this);
        Codec codec = ForgeHelper.conditionalCodec(BookType.CODEC);
        HashMap<ResourceLocation, BookType> bookTypes = new HashMap<ResourceLocation, BookType>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ((Optional)codec.parse((DynamicOps)ops, (Object)entry.getValue()).getOrThrow()).ifPresent(type -> bookTypes.put((ResourceLocation)entry.getKey(), (BookType)type));
        }
        this.setData(bookTypes);
    }

    public void setData(Map<ResourceLocation, BookType> bookTypes) {
        for (Map.Entry entry : this.itemToBooks.entries()) {
            AdditionalItemPlacementsAPI.unregisterPlacement((Item)((Item)entry.getKey()));
        }
        this.itemToBooks.clear();
        for (Map.Entry entry : bookTypes.entrySet()) {
            BookType value = (BookType)entry.getValue();
            this.books.register((ResourceLocation)entry.getKey(), (Object)value);
            Item item = value.item();
            if (this.itemToBooks.containsKey((Object)item)) {
                Supplementaries.LOGGER.warn("Duplicate book type for item: {}, overriding", (Object)item);
            }
            this.itemToBooks.put((Object)item, (Object)value);
            AdditionalItemPlacementsAPI.registerPlacement((Item)item, (AdditionalItemPlacement)(value.isHorizontal() ? this.horizontalPlacement : this.verticalPlacement));
        }
    }

    @Nullable
    public BookType get(Item item, boolean horizontal) {
        for (BookType entry : this.itemToBooks.get((Object)item)) {
            if (entry.isHorizontal() != horizontal && !CommonConfigs.Tweaks.MIXED_BOOKS.get().booleanValue()) continue;
            return entry;
        }
        return null;
    }

    public static void sendDataToClient(ServerPlayer player) {
        PlaceableBookManager instance = (PlaceableBookManager)((Object)INSTANCES.get((HolderLookup.Provider)player.level().registryAccess()));
        NetworkHelper.sendToClientPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientBoundSendBookDataPacket(instance.books.getEntries()));
    }
}

