/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SconceWallBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class SconceLeverBlock
extends SconceWallBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public SconceLeverBlock(BlockBehaviour.Properties properties, Supplier<SimpleParticleType> particleData) {
        super(properties, particleData);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            state.cycle((Property)POWERED);
            return InteractionResult.SUCCESS;
        }
        BlockState blockstate = this.setPowered(state, level, pos);
        boolean enabled = (Boolean)blockstate.getValue((Property)POWERED);
        float f = enabled ? 0.6f : 0.5f;
        level.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, f);
        level.gameEvent((Entity)player, (Holder)(enabled ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pos);
        return InteractionResult.CONSUME;
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemInteractionResult r = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        if (r.consumesAction()) {
            this.updateNeighbors(state, level, pos);
        }
        return r;
    }

    public BlockState setPowered(BlockState state, Level world, BlockPos pos) {
        state = (BlockState)state.cycle((Property)POWERED);
        world.setBlock(pos, state, 3);
        this.updateNeighbors(state, world, pos);
        return state;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.is(newState.getBlock()) && ((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            this.updateNeighbors(state, worldIn, pos);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.getValue((Property)POWERED) ^ (Boolean)blockState.getValue((Property)LIT) == false ? 15 : 0;
    }

    public int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.getValue((Property)POWERED) ^ (Boolean)blockState.getValue((Property)LIT) == false && SconceLeverBlock.getFacing(blockState) == side ? 15 : 0;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    private void updateNeighbors(BlockState state, Level world, BlockPos pos) {
        world.updateNeighborsAt(pos, (Block)this);
        world.updateNeighborsAt(pos.relative(SconceLeverBlock.getFacing(state).getOpposite()), (Block)this);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    protected static Direction getFacing(BlockState state) {
        return (Direction)state.getValue((Property)FACING);
    }

    @Override
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (!((Boolean)stateIn.getValue((Property)POWERED)).booleanValue()) {
            super.animateTick(stateIn, worldIn, pos, rand);
        } else if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            Direction direction = (Direction)stateIn.getValue((Property)FACING);
            double d0 = (double)pos.getX() + 0.5;
            double d1 = (double)pos.getY() + 0.65;
            double d2 = (double)pos.getZ() + 0.5;
            Direction direction1 = direction.getOpposite();
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + 0.125 * (double)direction1.getStepX(), d1 + 0.15, d2 + 0.125 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)this.particleData.get(), d0 + 0.125 * (double)direction1.getStepX(), d1 + 0.15, d2 + 0.125 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean tryLightUp(Entity entity, BlockState state, BlockPos pos, LevelAccessor world, ILightable.FireSoundType fireSourceType) {
        boolean ret = super.tryLightUp(entity, state, pos, world, fireSourceType);
        if (ret && world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            this.updateNeighbors(state, (Level)level, pos);
        }
        return ret;
    }

    public boolean tryExtinguish(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world) {
        boolean ret = super.tryExtinguish(player, state, pos, world);
        if (ret && world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            this.updateNeighbors(state, (Level)level, pos);
        }
        return ret;
    }
}

