/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.supplementaries.client.screens.BlackBoardScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public abstract class BlackboardButton
implements GuiEventListener,
Renderable,
NarratableEntry {
    protected final BlackBoardScreen parent;
    private final ResourceLocation outlineTexture;
    public final int size;
    public final int x;
    public final int y;
    protected boolean shouldDrawOverlay;
    protected byte color;
    protected boolean focused;

    public BlackboardButton(BlackBoardScreen screen, int x, int y, byte color, int size, ResourceLocation outlineTexture) {
        this.x = x;
        this.y = y;
        this.parent = screen;
        this.color = color;
        this.size = size;
        this.outlineTexture = outlineTexture;
    }

    public byte getColor() {
        return this.color;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.shouldDrawOverlay = this.isMouseOver(mouseX, mouseY);
        this.renderButton(graphics);
        if (this.isShouldDrawOverlay()) {
            this.renderHoverOverlay(graphics);
        }
    }

    protected abstract void renderButton(GuiGraphics var1);

    public void renderHoverOverlay(GuiGraphics graphics) {
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 90.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blitSprite(this.outlineTexture, this.x - 1, this.y - 1, this.size + 2, this.size + 2);
        pose.popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean flag;
        if (this.isValidClickButton(button) && (flag = this.isMouseOver(mouseX, mouseY))) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            this.onClick();
            return true;
        }
        return false;
    }

    protected abstract void onClick();

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    public boolean isShouldDrawOverlay() {
        return this.shouldDrawOverlay;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.size) && mouseY < (double)(this.y + this.size);
    }

    public void playDownSound(SoundManager handler) {
        handler.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }
}

