/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ConfigUtils;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkClientCompat;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;

public class ConfigButton
extends Button {
    public ConfigButton(int x, int y) {
        super(x, y, 20, 20, (Component)Component.literal((String)"s"), ConfigButton::click, Button.DEFAULT_NARRATION);
    }

    public int getFGColor() {
        return this.isHovered ? ColorHelper.getRainbowColorPost(3.0f) : 0xFFAA00;
    }

    public static void click(Button button) {
        ConfigUtils.openModConfigs();
    }

    public static void setupConfigButton(Screen screen, List<? extends GuiEventListener> listeners, Consumer<GuiEventListener> adder) {
        if (screen instanceof TitleScreen || screen instanceof PauseScreen) {
            boolean isOnRight = CompatHandler.QUARK ? QuarkClientCompat.shouldHaveButtonOnRight() : true;
            List<String> targets = isOnRight ? Arrays.asList(Component.translatable((String)"menu.online").getString(), Component.translatable((String)"fml.menu.modoptions").getString(), Component.translatable((String)"menu.shareToLan").getString()) : Arrays.asList(Component.translatable((String)"menu.options").getString(), Component.translatable((String)"fml.menu.mods").getString());
            for (GuiEventListener guiEventListener : listeners) {
                AbstractWidget b;
                String name;
                if (!(guiEventListener instanceof AbstractWidget) || !targets.contains(name = (b = (AbstractWidget)guiEventListener).getMessage().getString())) continue;
                int spacing = 4;
                ConfigButton button = new ConfigButton(b.getX() + (isOnRight ? b.getWidth() + spacing : -20 - spacing), b.getY() + ClientConfigs.General.CONFIG_BUTTON_Y_OFF.get());
                adder.accept((GuiEventListener)button);
                return;
            }
        }
    }
}

