/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class CannonFireParticle
extends TextureSheetParticle {
    private final SpriteSet ringSprites;
    private final SpriteSet boomSprites;
    private final double yaw;
    private final double pitch;
    private TextureAtlasSprite boomSprite;

    private CannonFireParticle(ClientLevel world, double x, double y, double z, double pitch, double yaw, SpriteSet ringSprites, SpriteSet boomSprites, float size) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.setParticleSpeed(0.0, 0.0, 0.0);
        this.pitch = pitch;
        this.yaw = yaw;
        this.ringSprites = ringSprites;
        this.boomSprites = boomSprites;
        this.lifetime = 5;
        this.hasPhysics = false;
        this.quadSize = 1.25f * size;
        this.setSpriteFromAge(ringSprites);
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.ringSprites);
    }

    public void setSpriteFromAge(SpriteSet sprite) {
        if (!this.removed) {
            this.setSprite(sprite.get(this.age, this.lifetime));
            this.boomSprite = this.boomSprites.get(this.age, this.lifetime);
        }
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 vec3 = renderInfo.getPosition();
        float px = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - vec3.x());
        float py = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - vec3.y());
        float pz = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - vec3.z());
        Quaternionf quaternionf = new Quaternionf();
        quaternionf.rotateY((float)this.yaw);
        quaternionf.rotateX((float)this.pitch);
        float scale = this.getQuadSize(partialTicks);
        Matrix4f mat = new Matrix4f();
        mat.translate(px, py, pz);
        mat.scale(scale, scale, scale);
        mat.rotate((Quaternionfc)quaternionf);
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int light = this.getLightColor(partialTicks);
        this.drawDoubleQuad(buffer, mat, 1.0f, 0.0f, u0, u1, v0, v1, light);
        mat.translate(0.0f, 0.0f, -0.25f);
        mat.rotate((Quaternionfc)RotHlpr.YN90);
        float U0 = this.boomSprite.getU0();
        float U1 = this.boomSprite.getU1();
        float V0 = this.boomSprite.getV0();
        float V1 = this.boomSprite.getV1();
        int i = (int)Math.min(4.0f, (float)this.age / (float)this.lifetime * 5.0f) + 1;
        float d = (float)i / 16.0f;
        float s = 0.25f;
        for (int j = 0; j < 4; ++j) {
            mat.rotate((Quaternionfc)RotHlpr.X90);
            this.drawDoubleQuad(buffer, mat, s, d, U0, U1, V0, V1, light);
        }
    }

    private void drawDoubleQuad(VertexConsumer buffer, Matrix4f mat, float w, float o, float u0, float u1, float v0, float v1, int light) {
        int lU = VertexUtil.lightU((int)light);
        int lV = VertexUtil.lightV((int)light);
        buffer.addVertex(mat, -w, -w, o).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lU, lV);
        buffer.addVertex(mat, -w, w, o).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lU, lV);
        buffer.addVertex(mat, w, w, o).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lU, lV);
        buffer.addVertex(mat, w, -w, o).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lU, lV);
        buffer.addVertex(mat, w, -w, o).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lU, lV);
        buffer.addVertex(mat, w, w, o).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lU, lV);
        buffer.addVertex(mat, -w, w, o).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lU, lV);
        buffer.addVertex(mat, -w, -w, o).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv2(lU, lV);
    }

    public int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    record SimpleSpriteSet(List<TextureAtlasSprite> sprites) implements SpriteSet
    {
        public TextureAtlasSprite get(int age, int lifetime) {
            return this.sprites.get((this.sprites.size() - 1) * age / lifetime);
        }

        public TextureAtlasSprite get(RandomSource random) {
            return this.sprites.get(random.nextInt(this.sprites.size()));
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;
        private final Supplier<SpriteSet> sprites2 = Suppliers.memoize(() -> {
            TextureAtlas atlas = (TextureAtlas)Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_PARTICLES);
            return new SimpleSpriteSet(List.of(atlas.getSprite(Supplementaries.res("cannon_bang_00")), atlas.getSprite(Supplementaries.res("cannon_bang_01")), atlas.getSprite(Supplementaries.res("cannon_bang_02")), atlas.getSprite(Supplementaries.res("cannon_bang_03")), atlas.getSprite(Supplementaries.res("cannon_bang_04")), atlas.getSprite(Supplementaries.res("empty"))));
        });

        public Factory(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double pitch, double yaw, double size) {
            Vec3 offset = Vec3.directionFromRotation((float)((float)pitch * 57.295776f), (float)(-((float)yaw) * 57.295776f));
            offset = offset.scale(-0.4063125);
            offset = offset.add(0.0, 0.0625, 0.0);
            offset = offset.scale(size);
            return new CannonFireParticle(worldIn, x + offset.x, y + offset.y + 0.0625, z + offset.z, pitch, yaw, this.sprites, this.sprites2.get(), (float)size);
        }
    }
}

