/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.neoforge.common.entity;

import net.chococraft.common.entity.AbstractChocobo;
import net.chococraft.common.items.ChocoboSaddleItem;
import net.chococraft.neoforge.common.inventory.NeoForgeSaddleBagMenu;
import net.chococraft.neoforge.common.inventory.SaddleItemStackHandler;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class NeoForgeChocobo
extends AbstractChocobo {
    public final ItemStackHandler inventory = new ItemStackHandler(45){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (NeoForgeChocobo.this.getSaddle().isEmpty()) {
                return false;
            }
            Item item = NeoForgeChocobo.this.getSaddle().getItem();
            if (item instanceof ChocoboSaddleItem) {
                ChocoboSaddleItem saddleItem = (ChocoboSaddleItem)item;
                switch (saddleItem.getInventorySize()) {
                    case 18: {
                        return (slot > 10 && slot < 16 || slot > 19 && slot < 25 || slot > 28 && slot < 34) && super.isItemValid(slot, stack);
                    }
                    case 45: {
                        return super.isItemValid(slot, stack);
                    }
                }
                return false;
            }
            return super.isItemValid(slot, stack);
        }
    };
    public final SaddleItemStackHandler saddleItemStackHandler = new SaddleItemStackHandler(){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.isEmpty() || stack.getItem() instanceof ChocoboSaddleItem;
        }

        @Override
        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            NeoForgeChocobo.this.setSaddleType(stack);
            super.setStackInSlot(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            NeoForgeChocobo.this.setSaddleType(this.getStackInSlot(slot));
            super.onContentsChanged(slot);
        }
    };

    public NeoForgeChocobo(EntityType<? extends AbstractChocobo> type, Level world) {
        super(type, world);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("Saddle", (Tag)this.saddleItemStackHandler.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        compound.put("Inventory", (Tag)this.inventory.serializeNBT((HolderLookup.Provider)this.registryAccess()));
    }

    @Override
    protected void setSaddled(Player player, InteractionHand hand, ItemStack heldItemStack) {
        if (!this.level().isClientSide) {
            this.saddleItemStackHandler.setStackInSlot(0, heldItemStack.getItem().getDefaultInstance());
            this.setSaddleType(heldItemStack);
            this.usePlayerItem(player, hand, heldItemStack);
        }
    }

    public void openCustomInventoryScreen(Player player) {
        if (!this.level().isClientSide && (!this.isVehicle() || this.hasPassenger((Entity)player)) && this.isTame()) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.containerMenu != player.inventoryMenu) {
                player.closeContainer();
            }
            serverPlayer.nextContainerCounter();
            serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((ix, playerInventory, playerEntityx) -> new NeoForgeSaddleBagMenu(ix, playerInventory, this), this.getDisplayName()), buf -> buf.writeUUID(this.getUUID()));
        }
    }

    @Override
    protected void reconfigureInventory(ItemStack oldSaddle, ItemStack newSaddle) {
        if (!this.getCommandSenderWorld().isClientSide) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (!this.isAlive()) continue;
                ItemStack stack = this.inventory.extractItem(i, Integer.MAX_VALUE, false);
                Containers.dropItemStack((Level)this.getCommandSenderWorld(), (double)this.getX(), (double)(this.getY() + 0.5), (double)this.getZ(), (ItemStack)stack);
            }
        }
        for (Player player : this.level().players()) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (!(abstractContainerMenu instanceof NeoForgeSaddleBagMenu)) continue;
            NeoForgeSaddleBagMenu bagContainer = (NeoForgeSaddleBagMenu)abstractContainerMenu;
            bagContainer.refreshSlots(bagContainer.getChocobo(), player.getInventory());
        }
    }

    @Override
    protected void dropInventory() {
        if (this.inventory != null && this.isSaddled()) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (this.inventory.getStackInSlot(i).isEmpty()) continue;
                this.spawnAtLocation(this.inventory.getStackInSlot(i), 0.0f);
            }
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.saddleItemStackHandler.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compound.getCompound("Saddle"));
        this.setSaddleType(this.saddleItemStackHandler.getStackInSlot(0));
        this.inventory.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compound.getCompound("Inventory"));
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }
}

