/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.util;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class ConfigHelper {
    public static Map<Item, Number[]> getItemsWithValues(List<? extends List<?>> source) {
        HashMap<Item, Number[]> map = new HashMap<Item, Number[]>();
        for (List<?> entry : source) {
            String itemID = (String)entry.get(0);
            if (itemID.startsWith("#")) {
                String tagID = itemID.replace("#", "");
                Optional<Pair> optionalTag = BuiltInRegistries.ITEM.getTags().filter(tag -> ((TagKey)tag.getFirst()).location().toString().equals(tagID)).findFirst();
                optionalTag.ifPresent(itemITag -> {
                    for (Holder item : ((HolderSet.Named)((Pair)optionalTag.get()).getSecond()).stream().toList()) {
                        map.put((Item)item.value(), new Number[]{(Number)entry.get(1), (Number)entry.get(2)});
                    }
                });
                continue;
            }
            Item newItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)itemID));
            if (newItem == null) continue;
            map.put(newItem, new Number[]{(Number)entry.get(1), (Number)entry.get(2)});
        }
        return map;
    }

    public static List<Item> getItems(List<? extends String> source) {
        ArrayList<Item> list = new ArrayList<Item>();
        for (String string : source) {
            if (string.startsWith("#")) {
                String tagID = string.replace("#", "");
                Optional<Pair> optionalTag = BuiltInRegistries.ITEM.getTags().filter(tag -> ((TagKey)tag.getFirst()).location().toString().equals(tagID)).findFirst();
                optionalTag.ifPresent(itemITag -> {
                    for (Holder item : ((HolderSet.Named)((Pair)optionalTag.get()).getSecond()).stream().toList()) {
                        list.add((Item)item.value());
                    }
                });
                continue;
            }
            Item newItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)string));
            if (newItem == null) continue;
            list.add(newItem);
        }
        return list;
    }
}

