/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin.create;

import com.simibubi.create.content.fluids.OpenEndedPipe;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.fluid.FluidHelper;
import dev.ghen.thirst.content.purity.WaterPurity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={OpenEndedPipe.class}, remap=false)
public class MixinOpenEndedPipe {
    @Inject(method={"removeFluidFromSpace"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void removeFluidFromSpace(boolean simulate, CallbackInfoReturnable<FluidStack> cir) {
        OpenEndedPipe pipe = (OpenEndedPipe)this;
        if (pipe.getWorld() != null && pipe.getWorld().isLoaded(pipe.getOutputPos())) {
            FluidStack stack;
            BlockState state = pipe.getWorld().getBlockState(pipe.getOutputPos());
            FluidState fluidState = state.getFluidState();
            boolean waterlog = state.hasProperty((Property)BlockStateProperties.WATERLOGGED);
            if (!fluidState.isEmpty() && fluidState.isSource() && (waterlog || state.canBeReplaced()) && FluidHelper.isWater((Fluid)(stack = new FluidStack(fluidState.getType(), 1000)).getFluid())) {
                WaterPurity.addPurity(stack, WaterPurity.getBlockPurity(pipe.getWorld(), pipe.getOutputPos()));
                if (simulate) {
                    cir.setReturnValue((Object)stack);
                } else {
                    AdvancementBehaviour.tryAward((BlockGetter)pipe.getWorld(), (BlockPos)pipe.getPos(), (CreateAdvancement)AllAdvancements.WATER_SUPPLY);
                    if (waterlog) {
                        pipe.getWorld().setBlock(pipe.getOutputPos(), (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
                        pipe.getWorld().scheduleTick(pipe.getOutputPos(), (Fluid)Fluids.WATER, 1);
                        cir.setReturnValue((Object)stack);
                    } else {
                        pipe.getWorld().setBlock(pipe.getOutputPos(), (BlockState)fluidState.createLegacyBlock().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(14)), 3);
                        cir.setReturnValue((Object)stack);
                    }
                }
            }
        }
    }
}

