/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin.create;

import com.simibubi.create.content.fluids.transfer.FluidDrainingBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import dev.ghen.thirst.content.purity.WaterPurity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FluidDrainingBehaviour.class}, remap=false)
public abstract class MixinFluidDrainingBehaviour {
    @Inject(method={"getDrainableFluid"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    public void getDrainableFluid(BlockPos rootPos, CallbackInfoReturnable<FluidStack> cir) {
        FluidDrainingBehaviour behaviour = (FluidDrainingBehaviour)this;
        FluidStack output = (FluidStack)cir.getReturnValue();
        if (FluidHelper.isWater((Fluid)output.getFluid())) {
            WaterPurity.addPurity(output, WaterPurity.getBlockPurity(behaviour.getWorld(), rootPos));
            cir.setReturnValue((Object)output);
        }
    }
}

