/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.content.purity;

import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ContainerWithPurity {
    private Item filledItem;
    private Item emptyItem;
    private final boolean isDrinkable;
    private final boolean isStatic;
    private Predicate<ItemStack> equalsFilled;
    private Predicate<ItemStack> equalsEmpty;
    private boolean canHarvestRunningWater;

    public ContainerWithPurity(Item emptyItem, Item filledItem) {
        this.emptyItem = emptyItem;
        this.filledItem = filledItem;
        this.isDrinkable = true;
        this.isStatic = false;
        this.canHarvestRunningWater = true;
        this.fillPredicates();
    }

    public ContainerWithPurity(Item emptyItem, Item filledItem, boolean isDrinkable) {
        this.emptyItem = emptyItem;
        this.filledItem = filledItem;
        this.isDrinkable = isDrinkable;
        this.isStatic = false;
        this.canHarvestRunningWater = true;
        this.fillPredicates();
    }

    public ContainerWithPurity(Item filledItem) {
        this.emptyItem = null;
        this.filledItem = filledItem;
        this.isDrinkable = true;
        this.isStatic = true;
        this.canHarvestRunningWater = false;
        this.fillPredicates();
    }

    public ContainerWithPurity canHarvestRunningWater(boolean canHarvestRunningWater) {
        this.canHarvestRunningWater = canHarvestRunningWater;
        return this;
    }

    public boolean canHarvestRunningWater() {
        return this.canHarvestRunningWater;
    }

    void fillPredicates() {
        this.equalsFilled = itemStack -> itemStack.getItem() == this.filledItem;
        this.equalsEmpty = itemStack -> itemStack.getItem() == this.emptyItem;
    }

    public ContainerWithPurity setEqualsEmpty(Predicate<ItemStack> predicate) {
        this.equalsEmpty = predicate;
        return this;
    }

    public ContainerWithPurity setEqualsFilled(Predicate<ItemStack> predicate) {
        this.equalsFilled = predicate;
        return this;
    }

    public boolean equalsEmpty(ItemStack item) {
        return !this.isStatic && this.equalsEmpty.test(item);
    }

    public boolean equalsFilled(ItemStack item) {
        return this.equalsFilled.test(item);
    }

    public boolean isDrinkable() {
        return this.isDrinkable;
    }

    public Item getFilledItem() {
        return this.filledItem;
    }

    public void setFilledItem(Item filledItem) {
        this.filledItem = filledItem;
    }

    public Item getEmptyItem() {
        return this.emptyItem;
    }

    public void setEmptyItem(Item emptyItem) {
        this.emptyItem = emptyItem;
    }
}

