/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.compat.supernatural;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.salju.supernatural.events.SupernaturalManager;
import net.salju.supernatural.init.SupernaturalItems;
import net.salju.supernatural.init.SupernaturalTags;

public class SupernaturalHelper {
    public static ResourceLocation VAMPIRE_THIRST_ICONS = ResourceLocation.fromNamespaceAndPath((String)"supernatural", (String)"textures/gui/thirst_icons.png");
    private static final ResourceLocation appleskinIcons = ResourceLocation.fromNamespaceAndPath((String)"supernatural", (String)"textures/gui/appleskin_icons.png");

    public static boolean canDrinkItem(ItemStack stack, Player player) {
        if (SupernaturalHelper.isVampireCheck(player)) {
            return SupernaturalHelper.isBloodCheck(stack);
        }
        return true;
    }

    public static boolean isVampireCheck(Player player) {
        return SupernaturalManager.isVampire((LivingEntity)player);
    }

    public static boolean hasVampirismCheck(Player player) {
        return SupernaturalManager.hasVampirism((LivingEntity)player);
    }

    public static boolean isBloodCheck(ItemStack stack) {
        return stack.is(SupernaturalTags.BLOOD);
    }

    public static Item getBloodBottle() {
        return (Item)SupernaturalItems.BLOOD.get();
    }

    public static ResourceLocation getVampireIcons(ResourceLocation original, Player player) {
        if (SupernaturalHelper.hasVampirismCheck(player)) {
            return VAMPIRE_THIRST_ICONS;
        }
        return original;
    }

    public static ResourceLocation getVampireIcons(ResourceLocation original, ItemStack stack) {
        if (SupernaturalHelper.isBloodCheck(stack)) {
            return VAMPIRE_THIRST_ICONS;
        }
        return original;
    }

    public static ResourceLocation getVampireAppleskinIcons(ResourceLocation original, Player player) {
        if (SupernaturalHelper.hasVampirismCheck(player)) {
            return appleskinIcons;
        }
        return original;
    }

    public static ResourceLocation getVampireAppleskinIcons(ResourceLocation original, ItemStack stack) {
        if (SupernaturalHelper.isBloodCheck(stack)) {
            return appleskinIcons;
        }
        return original;
    }
}

