/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.giantspawn_common_forge.events;

import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.HashMapFunctions;
import com.natamus.giantspawn_common_forge.config.ConfigHandler;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.level.Level;

public class GiantEvent {
    private static final HashMap<Level, CopyOnWriteArrayList<Giant>> giants_per_world = new HashMap();
    private static final HashMap<Level, Integer> tickdelay_per_world = new HashMap();

    public static void onEntityJoin(Level level, Entity entity) {
        if (level.isClientSide) {
            return;
        }
        if (!(entity instanceof Giant)) {
            return;
        }
        if (!((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(giants_per_world, (Object)level, k -> new CopyOnWriteArrayList())).contains(entity)) {
            giants_per_world.get(level).add((Giant)entity);
        }
        Giant giant = (Giant)entity;
        giant.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(35.0);
        giant.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)0.23f * ConfigHandler.giantMovementSpeedModifier);
        giant.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(3.0 * ConfigHandler.giantAttackDamageModifier);
        giant.getAttribute(Attributes.ARMOR).setBaseValue(2.0);
    }

    public static void onWorldTick(ServerLevel level) {
        int ticks = (Integer)HashMapFunctions.computeIfAbsent(tickdelay_per_world, (Object)level, k -> 1);
        if (ticks % 20 != 0) {
            tickdelay_per_world.put((Level)level, ticks + 1);
            return;
        }
        tickdelay_per_world.put((Level)level, 1);
        if (!ConfigHandler.shouldBurnGiantsInDaylight) {
            return;
        }
        if (!level.isDay()) {
            return;
        }
        for (Giant giant : (CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(giants_per_world, (Object)level, k -> new CopyOnWriteArrayList())) {
            if (giant.isAlive()) {
                BlockPos epos;
                if (giant.isInWaterRainOrBubble() || !giant.getItemBySlot(EquipmentSlot.HEAD).isEmpty() || !BlockPosFunctions.isOnSurface((Level)level, (BlockPos)(epos = giant.blockPosition())).booleanValue()) continue;
                giant.setRemainingFireTicks(60);
                continue;
            }
            giants_per_world.get(level).remove(giant);
        }
    }
}

