/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.config;

import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.config.CustomConfigScreen;
import dev.tr7zw.skinlayers.render.PreviewHelper;
import dev.tr7zw.skinlayers.versionless.ModBase;
import dev.tr7zw.skinlayers.versionless.config.Config;
import java.util.ArrayList;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ConfigScreenProvider {
    public static Screen createConfigScreen(Screen parent) {
        return new CustomConfigScreen(parent, "text.skinlayers.title"){

            @Override
            public void initialize() {
                Config config = SkinLayersModBase.config;
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getOnOffOption("text.skinlayers.enable.hat", () -> config.enableHat, b -> {
                    config.enableHat = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.jacket", () -> config.enableJacket, b -> {
                    config.enableJacket = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.leftsleeve", () -> config.enableLeftSleeve, b -> {
                    config.enableLeftSleeve = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.rightsleeve", () -> config.enableRightSleeve, b -> {
                    config.enableRightSleeve = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.leftpants", () -> config.enableLeftPants, b -> {
                    config.enableLeftPants = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.rightpants", () -> config.enableRightPants, b -> {
                    config.enableRightPants = b;
                }));
                options.add(this.getIntOption("text.skinlayers.renderdistancelod", 5, 40, () -> config.renderDistanceLOD, i -> {
                    config.renderDistanceLOD = i;
                }));
                options.add(this.getDoubleOption("text.skinlayers.basevoxelsize", 1.001f, 1.4f, 0.001f, () -> config.baseVoxelSize, i -> {
                    config.baseVoxelSize = i.floatValue();
                    SkinLayersModBase.instance.refreshLayers((Player)this.minecraft.player);
                }));
                options.add(this.getDoubleOption("text.skinlayers.headvoxelsize", 1.001f, 1.25f, 0.001f, () -> config.headVoxelSize, i -> {
                    config.headVoxelSize = i.floatValue();
                    SkinLayersModBase.instance.refreshLayers((Player)this.minecraft.player);
                }));
                options.add(this.getDoubleOption("text.skinlayers.bodyvoxelwidthsize", 1.001f, 1.4f, 0.001f, () -> config.bodyVoxelWidthSize, i -> {
                    config.bodyVoxelWidthSize = i.floatValue();
                    SkinLayersModBase.instance.refreshLayers((Player)this.minecraft.player);
                }));
                options.add(this.getOnOffOption("text.skinlayers.skulls.enable", () -> config.enableSkulls, b -> {
                    config.enableSkulls = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.skullsitems.enable", () -> config.enableSkullsItems, b -> {
                    config.enableSkullsItems = b;
                }));
                options.add(this.getDoubleOption("text.skinlayers.skulls.voxelsize", 1.001f, 1.2f, 0.001f, () -> config.skullVoxelSize, i -> {
                    config.skullVoxelSize = i.floatValue();
                }));
                options.add(this.getOnOffOption("text.skinlayers.fastrender.enable", () -> config.fastRender, b -> {
                    config.fastRender = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.compatibilityMode.enable", () -> config.compatibilityMode, b -> {
                    config.compatibilityMode = b;
                }));
                options.add(this.getDoubleOption("text.skinlayers.firstperson.voxelsize", 1.02f, 1.3f, 0.001f, () -> config.firstPersonPixelScaling, i -> {
                    config.firstPersonPixelScaling = i.floatValue();
                }));
                this.getOptions().addSmall(options.toArray(new OptionInstance[0]));
            }

            @Override
            public void save() {
                SkinLayersModBase.instance.writeConfig();
                SkinLayersModBase.instance.refreshLayers((Player)this.minecraft.player);
            }

            @Override
            public void render(GuiGraphics guiGraphics, int xMouse, int yMouse, float f) {
                super.render(guiGraphics, xMouse, yMouse, f);
                if (this.minecraft.level != null) {
                    int x = this.minecraft.getWindow().getGuiScaledWidth() / 2;
                    int y = this.minecraft.getWindow().getGuiScaledHeight() - 45;
                    int size = (int)(40.0f * ((float)this.minecraft.getWindow().getGuiScaledHeight() / 200.0f));
                    float lookX = x - xMouse;
                    float lookY = y - 80 - yMouse;
                    lookY = Math.min(lookY, 10.0f);
                    PreviewHelper.renderEntityInInventoryFollowsMouse(guiGraphics, x, y, size, lookX, lookY, (LivingEntity)this.minecraft.player);
                }
            }

            @Override
            public void reset() {
                ModBase.config = new Config();
                SkinLayersModBase.instance.writeConfig();
                SkinLayersModBase.instance.refreshLayers((Player)this.minecraft.player);
            }
        };
    }
}

