/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;

public class FilterTamed
extends FilterBase {
    protected boolean whitelistTamed = true;
    protected boolean includeTamable = true;

    public FilterTamed(EntityFilter filter) {
        super(filter);
    }

    public void setIncludeTamable(boolean includeTamable) {
        boolean prev = this.includeTamable;
        this.includeTamable = includeTamable;
        this.getFilter().nodeModified(this);
        this.includeTamable = prev;
    }

    public void setWhitelistTamed(boolean whitelistTamed) {
        boolean prev = this.whitelistTamed;
        this.whitelistTamed = whitelistTamed;
        this.getFilter().nodeModified(this);
        this.whitelistTamed = prev;
    }

    public boolean isIncludeTamable() {
        return this.includeTamable;
    }

    public boolean isWhitelistTamed() {
        return this.whitelistTamed;
    }

    @Override
    public boolean test(Entity entity) {
        if (entity instanceof Player) {
            return false;
        }
        boolean isTamable = entity instanceof TamableAnimal;
        if (isTamable) {
            TamableAnimal ownable = (TamableAnimal)entity;
            if (ownable.getOwnerUUID() != null) {
                return this.whitelistTamed;
            }
            return this.includeTamable;
        }
        return !this.whitelistTamed;
    }

    @Override
    public FilterType getType() {
        return FilterType.TAMED;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        compound.putBoolean("include", this.whitelistTamed);
        compound.putBoolean("tamable", this.includeTamable);
        return compound;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.whitelistTamed = nbt.getBoolean("include");
        this.includeTamable = nbt.getBoolean("tamable");
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        super.serializeMCD(output);
        output.writeBoolean(this.whitelistTamed);
        output.writeBoolean(this.includeTamable);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        super.deSerializeMCD(input);
        this.whitelistTamed = input.readBoolean();
        this.includeTamable = input.readBoolean();
    }
}

