/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.entity.extended_mobs;

import com.gametechbc.gametechbcsspellbooks.init.GSEntities;
import com.gametechbc.gametechbcsspellbooks.init.GSSpells;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.entity.mobs.dead_king_boss.DeadKingAnimatedWarlockAttackGoal;
import io.redspace.ironsspellbooks.entity.mobs.dead_king_boss.DeadKingBoss;
import io.redspace.ironsspellbooks.entity.mobs.goals.PatrolNearLocationGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.SpellBarrageGoal;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ExtendedDeadKingBoss
extends DeadKingBoss {
    public ExtendedDeadKingBoss(EntityType<? extends DeadKingBoss> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setPersistenceRequired();
        this.xpReward = 60;
    }

    public ExtendedDeadKingBoss(Level level) {
        this((EntityType<? extends DeadKingBoss>)((EntityType)GSEntities.EXTENDED_DEAD_KING.get()), level);
        this.setPersistenceRequired();
    }

    protected void setFinalPhaseGoals() {
        this.goalSelector.getAvailableGoals().forEach(WrappedGoal::stop);
        this.goalSelector.removeAllGoals(x -> true);
        this.goalSelector.addGoal(1, (Goal)new ExtendedDeadKingBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get(), 5, 5, 60, 140, 4));
        this.goalSelector.addGoal(2, (Goal)new ExtendedDeadKingBarrageGoal((IMagicEntity)this, (AbstractSpell)SpellRegistry.SUMMON_VEX_SPELL.get(), 3, 5, 400, 600, 1));
        this.goalSelector.addGoal(3, (Goal)new ExtendedDeadKingBarrageGoal((IMagicEntity)this, GSSpells.AERIAL_COLLAPSE_SPELL.get(), 4, 5, 240, 400, 1));
        this.goalSelector.addGoal(4, (Goal)new DeadKingAnimatedWarlockAttackGoal((DeadKingBoss)this, 1.0, 55, 85).setSpellQuality(0.6f, 0.8f).setSpells(List.of((AbstractSpell)SpellRegistry.BLOOD_SLASH_SPELL.get(), (AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get(), (AbstractSpell)SpellRegistry.WITHER_SKULL_SPELL.get(), GSSpells.ASHEN_BREATH.get(), (AbstractSpell)SpellRegistry.BLAZE_STORM_SPELL.get(), (AbstractSpell)SpellRegistry.ACID_ORB_SPELL.get()), List.of(GSSpells.METEOR_STORM_SPELL.get()), List.of((AbstractSpell)SpellRegistry.BLOOD_STEP_SPELL.get()), List.of()).setIsFlying().setSingleUseSpell(GSSpells.BLACKOUT_SPELL.get(), 10, 60, 3, 3).setMeleeBias(0.8f, 0.8f).setAllowFleeing(false));
        this.goalSelector.addGoal(5, (Goal)new PatrolNearLocationGoal((PathfinderMob)this, 32.0f, (double)0.9f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.hasUsedSingleAttack = false;
    }

    public static AttributeSupplier.Builder deadkingAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 12.0).add((Holder)AttributeRegistry.SPELL_POWER, 1.5).add(Attributes.ARMOR, 20.0).add((Holder)AttributeRegistry.SPELL_RESIST, 1.25).add(Attributes.MAX_HEALTH, 600.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.8).add(Attributes.ATTACK_KNOCKBACK, 0.6).add(Attributes.ENTITY_INTERACTION_RANGE, 4.0).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.MOVEMENT_SPEED, 0.155);
    }

    public boolean hurt(DamageSource source, float damage) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(source, damage);
        }
        damage = Math.min(this.DamageCap(), damage);
        return super.hurt(source, damage);
    }

    public float DamageCap() {
        return 20.0f;
    }

    private class ExtendedDeadKingBarrageGoal
    extends SpellBarrageGoal {
        public ExtendedDeadKingBarrageGoal(IMagicEntity abstractSpellCastingMob, AbstractSpell spell, int minLevel, int maxLevel, int pAttackIntervalMin, int pAttackIntervalMax, int projectileCount) {
            super(abstractSpellCastingMob, spell, minLevel, maxLevel, pAttackIntervalMin, pAttackIntervalMax, projectileCount);
        }

        public boolean canUse() {
            return !ExtendedDeadKingBoss.this.isMeleeing && super.canUse();
        }
    }
}

