/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.api.item.curio;

import com.gametechbc.gametechbcsspellbooks.api.item.curio.CurioBaseItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public abstract class HeavyAttributeCurio
extends CurioBaseItem {
    private final Multimap<Holder<Attribute>, AttributeModifier> attributeMap = HashMultimap.create();

    public HeavyAttributeCurio(Item.Properties properties, Map<Holder<Attribute>, AttributeModifier> attributes) {
        super(properties);
        for (Map.Entry<Holder<Attribute>, AttributeModifier> entry : attributes.entrySet()) {
            this.attributeMap.put(entry.getKey(), (Object)entry.getValue());
        }
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ItemStack stack) {
        ImmutableMultimap.Builder attributeBuilder = ImmutableMultimap.builder();
        for (Holder attributeHolder : this.attributeMap.keySet()) {
            for (AttributeModifier modifier : this.attributeMap.get((Object)attributeHolder)) {
                AttributeModifier newModifier = new AttributeModifier(new ResourceLocation(modifier.id().getNamespace(), modifier.id().getPath()), modifier.amount(), modifier.operation());
                attributeBuilder.put((Object)attributeHolder, (Object)newModifier);
            }
        }
        return attributeBuilder.build();
    }

    public abstract void appendHoverText(ItemStack var1, @Nullable Level var2, List<Component> var3, TooltipFlag var4);
}

