/*
 * Decompiled with CFR 0.152.
 */
package fuzs.airhop.network.client;

import com.google.common.base.Predicates;
import fuzs.airhop.AirHop;
import fuzs.airhop.config.ServerConfig;
import fuzs.airhop.init.ModRegistry;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import fuzs.puzzleslib.api.network.v3.ServerMessageListener;
import fuzs.puzzleslib.api.network.v3.ServerboundMessage;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public record ServerboundAirHopMessage() implements ServerboundMessage<ServerboundAirHopMessage>
{
    public ServerMessageListener<ServerboundAirHopMessage> getHandler() {
        return new ServerMessageListener<ServerboundAirHopMessage>(this){

            public void handle(ServerboundAirHopMessage message, MinecraftServer server, ServerGamePacketListenerImpl handler, ServerPlayer player, ServerLevel level) {
                player.jumpFromGround();
                player.fallDistance = 0.0f;
                ModRegistry.AIR_HOPS_ATTACHMENT_TYPE.update((Object)player, airHops -> {
                    airHops = (byte)(airHops + 1);
                    return airHops;
                });
                float airHopExhaustion = 3.0f;
                player.causeFoodExhaustion(player.isSprinting() ? 0.6f : 0.15f);
                this.damageBoots(level, player);
                this.playEffects(level, player);
            }

            private void damageBoots(ServerLevel level, ServerPlayer player) {
                if (player.getRandom().nextDouble() < ((ServerConfig)AirHop.CONFIG.get(ServerConfig.class)).damageChance) {
                    Optional optional = EnchantmentHelper.getRandomItemWith((DataComponentType)((DataComponentType)ModRegistry.AIR_HOP_ENCHANTMENT_EFFECT_COMPONENT_TYPE.value()), (LivingEntity)player, (Predicate)Predicates.alwaysTrue());
                    optional.ifPresent(enchantedItemInUse -> ItemHelper.hurtAndBreak((ItemStack)enchantedItemInUse.itemStack(), (int)1, (ServerLevel)level, (ServerPlayer)player, (Consumer)enchantedItemInUse.onBreak()));
                }
            }

            private void playEffects(ServerLevel level, ServerPlayer player) {
                if (((ServerConfig)AirHop.CONFIG.get(ServerConfig.class)).summonCloud) {
                    level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, player.getX(), player.getY(), player.getZ(), 15, 0.25, 0.0, 0.25, (double)0.01f);
                }
                if (((ServerConfig)AirHop.CONFIG.get(ServerConfig.class)).hopSound) {
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModRegistry.ENTITY_PLAYER_HOP_SOUND_EVENT.value(), player.getSoundSource(), 1.0f, 0.6f + player.getRandom().nextFloat() * 0.8f);
                }
            }
        };
    }
}

