/*
 * Decompiled with CFR 0.152.
 */
package fuzs.airhop.handler;

import fuzs.airhop.AirHop;
import fuzs.airhop.config.ServerConfig;
import fuzs.airhop.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PlayerFallHandler {
    public static EventResult onLivingFall(LivingEntity entity, MutableFloat fallDistance, MutableFloat damageMultiplier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            byte airHops = (Byte)ModRegistry.AIR_HOPS_ATTACHMENT_TYPE.getOrDefault((Object)player, (Object)0);
            if (!((ServerConfig)AirHop.CONFIG.get(ServerConfig.class)).fallDamage && airHops > 0) {
                fallDistance.mapFloat(distance -> Float.valueOf(Math.max(0.0f, distance.floatValue() - (float)airHops * PlayerFallHandler.getJumpHeight(player))));
            }
        }
        return EventResult.PASS;
    }

    public static void onStartPlayerTick(Player player) {
        if (player.onGround()) {
            ModRegistry.AIR_HOPS_ATTACHMENT_TYPE.set((Object)player, (Object)0);
        }
    }

    public static float getJumpHeight(Player player) {
        float jumpHeight = 1.25f;
        if (player.hasEffect(MobEffects.JUMP)) {
            jumpHeight += 0.6875f * ((float)player.getEffect(MobEffects.JUMP).getAmplifier() + 1.0f);
        }
        return jumpHeight;
    }
}

