/*
 * Decompiled with CFR 0.152.
 */
package net.countered.counteredsaccuratehitboxes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.countered.counteredsaccuratehitboxes.client.ModRenderLayers;
import net.countered.counteredsaccuratehitboxes.client.ModStuckObjectsFeatureRenderer;
import net.countered.counteredsaccuratehitboxes.mixin.accessors.AnimalModelAccessor;
import net.countered.counteredsaccuratehitboxes.mixin.accessors.MixinCuboidAccessor;
import net.countered.counteredsaccuratehitboxes.mixin.accessors.ModelPartAccessor;
import net.countered.counteredsaccuratehitboxes.util.HitboxAttachment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class HitboxFeatureRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends ModStuckObjectsFeatureRenderer<T, M> {
    private static final List<EntityType> babyAllowed = new ArrayList<EntityType>();

    public HitboxFeatureRenderer(EntityRendererProvider.Context context, LivingEntityRenderer<T, M> entityRenderer) {
        super(entityRenderer);
    }

    @Override
    protected void renderAtPart(List<ModelPart> modelPartList, PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float tickDelta) {
        ArrayList<List<Vector3f>> vertexCol = new ArrayList<List<Vector3f>>();
        if (entity.isBaby() && !babyAllowed.contains(entity.getType())) {
            return;
        }
        EntityModel model = this.getParentModel();
        for (ModelPart modelPart : modelPartList) {
            HashSet<ModelPart> excludedParts = new HashSet<ModelPart>();
            vertexCol.addAll(this.createHitboxes(matrices, modelPart, entity, vertexConsumers, light, excludedParts));
        }
        entity.setAttached(HitboxAttachment.HITBOXES, vertexCol);
    }

    private List<List<Vector3f>> createHitboxes(PoseStack matrices, ModelPart modelPart, T entity, MultiBufferSource vertexConsumers, int light, Set<ModelPart> excludedParts) {
        if (modelPart.hasChild("hat_rim")) {
            excludedParts.add(modelPart.getChild("hat_rim"));
        }
        if (excludedParts.contains(modelPart)) {
            return Collections.emptyList();
        }
        ArrayList<List<Vector3f>> vertexList = new ArrayList<List<Vector3f>>();
        matrices.pushPose();
        if (entity.isBaby()) {
            this.scaleBabyMatices(entity, modelPart, matrices);
        }
        if (entity.getType().equals(EntityType.RABBIT)) {
            matrices.scale(0.6f, 0.6f, 0.6f);
            matrices.translate(0.0f, 1.0f, 0.0f);
        }
        if (modelPart.visible) {
            List<ModelPart.Cube> cuboids = ((ModelPartAccessor)modelPart).getCuboids();
            modelPart.translateAndRotate(matrices);
            for (ModelPart.Cube cuboid : cuboids) {
                List<Vector3f> vertices = this.getCuboidHitbox(cuboid, modelPart, matrices);
                Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
                Vec3 cameraPos = camera.getPosition();
                for (Vector3f vertex : vertices) {
                    vertex.add((Vector3fc)cameraPos.toVector3f());
                }
                vertexList.add(vertices);
            }
            for (ModelPart modelChildren : ((ModelPartAccessor)modelPart).getChildren().values()) {
                vertexList.addAll(this.createHitboxes(matrices, modelChildren, entity, vertexConsumers, light, excludedParts));
            }
        }
        matrices.popPose();
        return vertexList;
    }

    private void scaleBabyMatices(T entity, ModelPart modelPart, PoseStack matrices) {
        EntityModel entityModel = this.getParentModel();
        if (entityModel instanceof HumanoidModel) {
            HumanoidModel model = (HumanoidModel)entityModel;
            if (modelPart.equals(model.head)) {
                matrices.scale(0.75f, 0.75f, 0.75f);
                matrices.translate(0.0f, 1.0f, 0.0f);
                return;
            }
        } else {
            entityModel = this.getParentModel();
            if (entityModel instanceof AgeableListModel) {
                AgeableListModel model = (AgeableListModel)entityModel;
                ArrayList headPartList = new ArrayList();
                ((AnimalModelAccessor)model).getHeadParts().forEach(part -> headPartList.add((ModelPart)part));
                if (!headPartList.isEmpty() && ((ModelPart)headPartList.get(0)).equals(modelPart)) {
                    matrices.translate(0.0f, ((AnimalModelAccessor)model).getChildHeadYOffset() / 16.0f, ((AnimalModelAccessor)model).getChildHeadZOffset() / 16.0f);
                    return;
                }
            }
        }
        matrices.scale(0.5f, 0.5f, 0.5f);
        matrices.translate(0.0, 1.5, 0.0);
    }

    public List<Vector3f> getCuboidHitbox(ModelPart.Cube cuboid, ModelPart modelPart, PoseStack matrices) {
        float x1 = cuboid.minX / 16.0f;
        float y1 = cuboid.minY / 16.0f;
        float z1 = cuboid.minZ / 16.0f;
        float x2 = cuboid.maxX / 16.0f;
        float y2 = cuboid.maxY / 16.0f;
        float z2 = cuboid.maxZ / 16.0f;
        Vector3f[] cubeVerts = new Vector3f[]{new Vector3f(x1, y1, z1), new Vector3f(x2, y1, z1), new Vector3f(x1, y2, z1), new Vector3f(x2, y2, z1), new Vector3f(x1, y1, z2), new Vector3f(x2, y1, z2), new Vector3f(x1, y2, z2), new Vector3f(x2, y2, z2)};
        Matrix4f matrix = matrices.last().pose();
        for (int i = 0; i < cubeVerts.length; ++i) {
            cubeVerts[i] = matrix.transformPosition(cubeVerts[i]);
        }
        return Arrays.asList(cubeVerts);
    }

    private void makePartGlow(Entity entity, MultiBufferSource vertexConsumers, PoseStack matrices, int overlay, int light, ModelPart.Cube cuboid, ModelPart modelPart) {
        float pulse = (Mth.sin((float)((float)entity.tickCount * 0.25f)) + 1.0f) / 2.0f;
        int alpha = (int)(pulse * 80.0f) + 100;
        int red = 250;
        int green = 30;
        int blue = 30;
        int color = alpha << 24 | red << 16 | green << 8 | blue;
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(ModRenderLayers.WEAK_SPOT_LAYER);
        PoseStack.Pose entry = matrices.last();
        Matrix4f matrix4f = entry.pose();
        Vector3f vector3f = new Vector3f();
        for (ModelPart.Polygon quad : ((MixinCuboidAccessor)cuboid).getSides()) {
            Vector3f vector3f2 = entry.transformNormal(quad.normal, vector3f);
            float f = vector3f2.x();
            float g = vector3f2.y();
            float h = vector3f2.z();
            for (ModelPart.Vertex vertex : quad.vertices) {
                Vector3f transformedPos = new Vector3f(vertex.pos.x() / 16.0f, vertex.pos.y() / 16.0f, vertex.pos.z() / 16.0f);
                transformedPos = matrix4f.transformPosition(transformedPos);
                vertexConsumer.addVertex(transformedPos.x(), transformedPos.y(), transformedPos.z(), color, vertex.u, vertex.v, overlay, light, f, g, h);
            }
        }
    }

    static {
        babyAllowed.add(EntityType.ZOMBIE);
        babyAllowed.add(EntityType.ZOMBIE_VILLAGER);
        babyAllowed.add(EntityType.PIGLIN);
        babyAllowed.add(EntityType.ZOMBIFIED_PIGLIN);
        babyAllowed.add(EntityType.COW);
        babyAllowed.add(EntityType.PIG);
        babyAllowed.add(EntityType.SHEEP);
    }
}

